import { transparentize } from "polished";
import { createGlobalStyle } from "styled-components";
import i18next from "i18next";
import {} from "next-i18next";
import { parseCookies } from "nookies";

var cookie = parseCookies().language;

export default createGlobalStyle`

    *{
        margin:0;

        padding: 0;

        box-sizing: border-box;
    }

    html,
    body{
        overflow-x:hidden;
    }

    body{
        background-color: ${(p) => p.theme.pageBackground};
        color: ${(p) => p.theme.pageForeground};
        font-family: 'Poppins', sans-serif;
    }

  .Pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    list-style: none;
    margin-top:25px;
    li {
      a {
        padding: 0 8px;
        min-width: 28px;
        height: 34px;
        transition: .25s ease;
        display: flex;
        justify-content: center;
        align-items: center;
        text-decoration: none;
        background-color: ${(p) => p.theme.inactiveElementBackground};
        color: ${(p) => p.theme.inactiveElementForeground};
        border-radius: ${(p) => p.theme.borderRadius};
        font-size: 12px;
        margin: 0 2px;
      }
      &.disabled a {
        cursor: not-allowed;
        opacity: ${(p) => p.theme.inactiveElementOpacity};
      }
      &.selected a {
        background-color: ${(p) => p.theme.primaryBackground};
        color: ${(p) => p.theme.primaryForeground};
        cursor: default;
        &::before {
          content: "${() => (cookie == "en" ? "Page" : ("Página" as string))}";;
          display: inline-block;
          margin-right: 4px;
        }
      }
      &:not(.selected,.disabled) {
        &:hover,
        &:focus {
          a {
            transform: translateY(-3px);
            box-shadow: 0 3px 6px ${(p) => transparentize(0.9, p.theme.pageForeground)};
          }
        }
      }
    }
  }
  // ------- overwrite css input prime react
    .p-inputtext {
      background: #ffffff 0% 0% no-repeat padding-box;
      box-shadow: 0px 3px 10px #00000021;
      border-radius: 4px;
      opacity: 1;
      width: 100%;
      border: none;
      font-family: 'Poppins', sans-serif;
      
      &::placeholder {
        color: #c3c3c3;
        font-size: 16px;
      }
    
    }
    .p-input-icon-left {
      width: 100%;
      font-size: 16px;
      .p-inputtext:enabled:hover {
        border-color: none;
      }
      .p-inputtext:enabled:focus {
        background: #ffffff 0% 0% no-repeat padding-box;
        box-shadow: 0px 3px 10px #00000021;
      }
    }
      .p-inputtext-md{
        height: 45px;
      }
  // ------- overwrite css input prime react

  // ------- overwrite css Dialog prime react
  .p-dialog {
    width: 500px;
    min-width: 300px;
    max-width: 500px;
    margin: 10px;
    font-family: "Poppins", sans-serif;
    border-radius: ${(p) => p.theme.borderRadius};
    p {
      text-align: center;
    }

    .p-dialog-header-icons {
      .p-dialog-header-icon {
        border: none;
        :active,
        &:focus {
          box-shadow: 0 0 0 2px ${(p) => transparentize(0.7, p.theme.primaryBackground)};
        }
      }
    }
    
  }


  // ------- overwrite css Dialog prime react




   // ------- overwrite css Sidebar prime react


  .p-component-overlay{
      height: 100vh;

  } 
  .p-sidebar{
    font-family: 'Poppins', sans-serif;
    box-shadow: 0 3px 6px ${(p) => transparentize(0.9, p.theme.pageForeground)};
    color: ${(p) => p.theme.pageForeground};
    list-style: none;
    height: 100%;
    max-width: 240px;

    h3 {
      text-align: center;
    }

    .li-active{
        background-color: ${(p) => transparentize(0.6, p.theme.inactiveElementBackground)};
      
      }

    li{
      width: 100%;
      border-bottom: 1px solid ${(p) => transparentize(0.9, p.theme.pageForeground)};
    }

      a {
        height: 40px;
        color: ${(p) => p.theme.pageForeground};
        text-decoration: none;
        text-transform: capitalize;
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        align-items: center;
        padding-left:10px;
       

        text {
          width: 90%;
          text-align: left;
          font: normal normal 600 12px/13px Poppins;
          letter-spacing: 0px;
          color: #006993;
          opacity: 1;
        }
        &:hover,
        &:focus,
        &:active {
          color: ${(p) => p.theme.activeElementForeground};
          background-color: ${(p) => transparentize(0.6, p.theme.inactiveElementBackground)};
        }
    }

    .p-sidebar-content{
      padding: 0 0;
      margin: 0 0 0 0;
      height: 100%;

      .logout-item{
        cursor: pointer;
        position: absolute;
        bottom: 0px;
        width: 100%;
        display: flex;
        align-self: flex-end;
        border: none;

        text{
          color:${(p) => p.theme.red}
        }

        li{
          border: none;
        }
      }
    }

    .p-sidebar-header .p-sidebar-close:enabled:hover,
    .p-sidebar-header .p-sidebar-icon{
      border: none;

      :enabled:hover {
        color: #495057;
        border-color: transparent;
        background:  ${(p) => transparentize(0.8, p.theme.inactiveElementBackground)};
      }
      :active,
      &:focus {
        box-shadow: 0 0 0 2px ${(p) => transparentize(0.7, p.theme.primaryBackground)};
      }
    }
}


 // ------- overwrite css Sidebar prime react

 // ------- Formik form
  .form-control {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    margin: 20px 0;
    background-color: transparent;
  }
 // ------- Formik form


  // ------- Prime Checkbox

  .p-checkbox .p-checkbox-box.p-highlight {
    border-color: ${(p) => p.theme.primaryBackground};
    background: ${(p) => p.theme.primaryBackground};
  } 
  .p-checkbox .p-checkbox-box.p-highlight:not(.p-disabled):hover {
    border-color: ${(p) => p.theme.secondaryBackground};
    background: ${(p) => p.theme.secondaryBackground};
    color: #ffffff;
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box:hover {
    border-color: ${(p) => p.theme.primaryBackground};
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box.p-focus {
    outline: 0 none;
    outline-offset: 0;
    box-shadow: 0 0 0 2px ${(p) => transparentize(0.7, p.theme.primaryBackground)};
    border-color: ${(p) => p.theme.primaryBackground};
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box.p-highlight:hover {
    border-color: ${(p) => p.theme.secondaryBackground};
    background: ${(p) => p.theme.secondaryBackground};
    color: #ffffff;
  }
  .p-checkbox:not(.p-checkbox-disabled) .p-checkbox-box.p-focus {
    outline: 0 none;
    outline-offset: 0;
    box-shadow: 0 0 0 2px ${(p) => transparentize(0.7, p.theme.primaryBackground)};
    border-color: ${(p) => p.theme.primaryBackground};;
  }
  .p-field-checkbox{
    label{
      font-size: 14px;
    }
  }
  // ------- Prime Checkbox


//Google map css
.gm-style .gm-style-iw-c {
  padding: 0;
}
.gm-style-iw-d{
  overflow: auto !important;
  
}
.gm-ui-hover-effect{
  width: 25px !important;;
  height: 25px !important;;
  background-color: ${(p) => transparentize(0.6, p.theme.activeElementBackground)} !important;
  position: absolute !important;
  right: 5px !important;
  top: 5px !important;
  padding: 0 0 !important;
  display: flex !important;
  justify-content: center !important;
  align-items: center !important;
  border-radius: 100px;
  
  img{
    width: 20px !important;
    height: auto !important;
    margin: auto !important;
    align-self: center !important;
    align-items: center !important;
  }

}

//Google map css

//Map cluster

.cluster{
  object-fit: cover;
  display: flex;
  justify-content: center;
  align-items: center;

  img{
    height: auto;
    width:100%;
  }

}
//Map cluster


/// primeReact Menu override css
  .p-tieredmenu {
    border-radius: ${(p) => p.theme.borderRadius}
  }

  .p-submenu-list .p-submenu-list-flipped{
    border-radius: ${(p) => p.theme.borderRadius}
  }
  .p-submenu-list{
    border-radius: ${(p) => p.theme.borderRadius}
  }

  .p-menuitem .p-menuitem-active{
    background-color: ${(p) => transparentize(0.6, p.theme.inactiveElementBackground)};
  }

  .p-tieredmenu .p-menuitem-link .p-menuitem-text {
    color: #495057;
    font-family: Poppins;
  }

  /// primeReact Menu override css


  /// Input swtich
  .p-inputswitch .p-inputswitch-slider {
    background: ${(p) => p.theme.inactiveElementBackground};
    transition: background-color 0.2s, color 0.2s, border-color 0.2s, box-shadow 0.2s;
    border-radius: 30px;
  }

  .p-inputswitch.p-inputswitch-checked .p-inputswitch-slider {
    background: ${(p) => p.theme.primaryBackground};
  }

  .p-inputswitch.p-inputswitch-checked:not(.p-disabled):hover .p-inputswitch-slider {
    background: ${(p) => p.theme.secondaryBackground};
  }
  
  .mini-switch{
    .p-inputswitch{
      position: absolute;
      right: 18px;
      height: 20px;
      width: 40px;
  
    }
    .p-inputswitch .p-inputswitch-slider:before {
      background: #ffffff;
      width: 15px;
      height: 15px;
      left: 0.15rem;
      margin-top: -0.475rem;
      border-radius: 50%;
      -webkit-transition-duration: 0.2s;
      transition-duration: 0.2s;
    }
  }

  .Dropdown-arrow{
      top: 20px;
  }

  .select-filter{
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    padding: 6px 12px;
    font-size: 16px;
    line-height: 1.42857143;
    color: #555;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    background: #ffffff 0% 0% no-repeat padding-box;
    box-shadow: 0px 3px 10px #00000021;
    border-color: none;
    border: none;
    outline: none;
    padding-left: 40px;
    height: 45px;
    font-family: "Poppins";
  }

    .Dropdown-control {
        :hover{
          box-shadow: 0px 3px 10px #00000021;
        }
      }

    .dropdown-filter{
      border: none;
      border-radius: ${(p) => p.theme.borderRadius};
      .Dropdown-option{
        :hover{
          background-color: ${(p) => transparentize(0.6, p.theme.inactiveElementBackground)};
        }
      }
      .is-selected{
        background-color: ${(p) => transparentize(0.6, p.theme.inactiveElementBackground)};
      }
    }

  /// Datatable override

  .datatable-responsive .p-datatable-responsive .p-datatable-tbody > tr > td .p-column-title {
      display: none;
  }

  .datatable-responsive .p-datatable-responsive .p-datatable-tbody > tr > td {
    text-align: center;
    word-break: break-all;
  }

  .datatable-responsive .p-datatable-responsive .p-datatable-thead > tr > th {
    text-align: center;
  }

  @media screen and (max-width: 50em) {
      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-thead > tr > th,
      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tfoot > tr > td {
          display: none !important;
      }

      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tbody > tr > td {
          text-align: left;
          display: block;
          width: 100%;
          float: left;
          clear: left;
          border: 0 none;
      }

      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tbody > tr > td .p-column-title {
          padding: .4rem;
          min-width: 30%;
          display: inline-block;
          margin: -.4em 1em -.4em -.4rem;
          font-weight: bold;
      }

      .datatable-responsive .p-datatable.p-datatable-responsive .p-datatable-tbody > tr > td:last-child {
          border-bottom: 1px solid var(--surface-d);
      }
  }

  /*========== SCROLL BAR ==========*/
  ::-webkit-scrollbar{
      width: .60rem;
      background-color: hsl(230, 12%, 90%);
      border-radius: .5rem;
  }

  ::-webkit-scrollbar-thumb{
      background-color: hsl(230, 12%, 80%);
      border-radius: .5rem;
  }

  ::-webkit-scrollbar-thumb:hover{
      background-color: hsl(230, 8%, 65%);
  }
`;
