import { transparentize } from "polished";
import styled from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  width: 100%;
  max-width: 800px;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  margin: auto;

  padding: 10px 10px;
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  border-radius: ${(p) => p.theme.borderRadius};
  background-color: ${(p) => p.theme.activeElementBackground};
  position: relative;

  form {
    max-width: 700px;
    padding: 5px;
    width: 100%;
  }
`;

export const Title = styled.text`
  font: normal normal 600 24px/18px Poppins;
  margin: 20px 0;
`;
export const RegisterImage = styled.div<{ url: string }>`
  width: 130px;
  height: 130px;
  background-image: url(${(p) => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;

  input {
    width: 92px;
    height: 92px;
    border-radius: 100px;
    display: none;
  }
`;

export const TextContainer = styled.div`
  text-align: center;
`;

export const Text = styled.text`
  font: normal normal normal 16px/25px Poppins;
  text-align: center;
  color: #c3c3c3;
`;

export const TextLink = styled.a`
  text-decoration: underline;
  color: ${(p) => p.theme.primaryBackground};
  cursor: pointer;
`;
export const ButtonContainer = styled.div`
  margin-top: 40px;
`;
