import styled from "styled-components";

export const Wrapper = styled.div`
  width: 100%;
  height: 100%;
  display: flex;
  justify-content: center;
  padding: 20px;
`;

export const Container = styled.div`
  display: flex;
  flex: 1;
  flex-direction: column;
  max-width: 600px;
  justify-content: center;
  align-items: center;

  span {
    width: 100%;
    margin-top: 24px;
  }
`;

export const Icon = styled.div`
  width: 200px;
  background-image: url("/assets/icon.png");
  height: 200px;
  cursor: pointer;
  background-position: center;
  background-size: cover;
`;

export const ForgotPassword = styled.label`
  color: ${(p) => p.theme.primaryBackground};
  cursor: pointer;
  text-align: center;

  &:hover {
    text-decoration: underline;
  }
`;
