import { transparentize } from "polished";
import styled from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  width: 100%;
  max-width: 800px;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  margin: auto;

  padding: 10px 10px;
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  border-radius: ${(p) => p.theme.borderRadius};
  background-color: ${(p) => p.theme.activeElementBackground};
  position: relative;

  form {
    max-width: 700px;
    width: 100%;
    padding: 5px;
  }
`;

export const RegisterImage = styled.div<{ url: string }>`
  width: 130px;
  height: 130px;
  background-image: url(${(p) => p.url});
  background-position: center;
  background-size: cover;
  border-radius: 100px;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;

  input {
    width: 92px;
    height: 92px;
    border-radius: 100px;
    display: none;
  }
`;

export const InputGroup = styled.div<{ inputs: number }>`
  display: grid;
  width: 100%;
  justify-content: center;
  flex-wrap: wrap;

  @media screen and (min-width: 768px) {
    grid-template-columns: repeat(${(p) => p.inputs || 1}, 1fr);
  }

  @media screen and (max-width: 768px) {
    display: flex;
    justify-content: center;
    align-items: center;
  }
`;

export const Title = styled.text`
  font: normal normal 600 24px/18px Poppins;
  margin: 20px 0;
`;

export const InputContainer = styled.div`
  width: 100%;
  display: flex;
`;

export const ButtonContainer = styled.div`
  width: 100%;
  display: flex;
  margin-top: 20px;
  justify-content: center;
  align-items: center;
`;
