import styled from "styled-components";
import { transparentize } from "polished";

export const Row = styled.div<{ col?: number }>`
    display: grid;
    position: relative;
    grid-template-columns: repeat(${(p) => p.col || '2'}, 1fr);
    justify-content: center;
    align-items: center;
    margin: auto;
    flex-direction: row;
    gap: 10px;
    padding: 10px 10px;
    max-width: 100%;

    @media screen and (max-width: 450px) {
        grid-template-columns: repeat(1, 1fr);
    }
`
export const Column = styled.div`
    
    text-align: center;
    display: flex;
    width: 100%;
    flex-direction: column;
    padding: 10px 10px;
    align-itens: center;

    box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
    border-radius: ${(p) => p.theme.borderRadius};
    background-color: ${(p) => p.theme.activeElementBackground};
`

export const Container = styled.div`
    display: flex;
    width: 100%;
    justify-content: center;
`;

export const ContainerText = styled.div`
    flex-direction: column;
    width: 100%;
    justify-content: center;
    display: grid;
`;

export const Text = styled.text<{ fontSize?: number, fontWeight?: number }>`
    font: normal normal ${(p) => p.fontWeight || 'normal'} ${(p) => p.fontSize || 16}px Poppins;
    margin: 20px 0;
    text-align: center;
`;

export const InputGroup = styled.div<{ inputs: number }>`
    display: grid;
    width: 100%;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;

    @media screen and (min-width: 768px) {
        grid-template-columns: repeat(${(p) => p.inputs || 1}, 1fr);
    }

    @media screen and (max-width: 768px) {
        display: flex;
        justify-content: center;
        align-items: center;
    }
`;

export const NoData = styled.div`
    margin: auto;
    margin-top: 50px;

    h2 {
        text-align: center;
    }
`;