import Head from "next/dist/shared/lib/head";
import { GetServerSideProps } from "next";
import { Util } from "../../../../core/utils/util";
import { parseCookies } from "nookies";
import { serverSideTranslations } from "next-i18next/serverSideTranslations";
import Content from "../../../../app/components/Content";
import { Column, Container, ContainerText, Text, Row, InputGroup, NoData } from "./styles";
import { useCallback, useEffect, useState } from "react";
import useEstablishment from "../../../../core/hooks/useEstablishment";
import { Input } from "../../../../app/components/CustomInput/styles";
import { FaSearch } from "react-icons/fa";
import CardAdventure from "../../../../app/components/CardAdventure";

const Overview = () => {
  const { getDataOverview } = useEstablishment();
  const [overview, setOverview] = useState({});
  const [dateInputs, setDateInputs] = useState({
    dataInicial: new Date(new Date().getFullYear(), new Date().getMonth() - 1)
      .toLocaleDateString('pt-br')
      .split("/")
      .reverse()
      .join("-"),
    dataFinal: new Date().toLocaleDateString('pt-br').split("/").reverse().join("-"),
  });

  const getDataOverviewDto = useCallback(async (dateInputs) => {
    const response = await getDataOverview(dateInputs);
    setOverview(response.data);
  }, []);

  useEffect(() => {
    getDataOverviewDto(dateInputs);
  }, [getDataOverviewDto]);

  return (
    <>
      <Head>
        <title>Relty - Minhas aventuras</title>
        <meta name="description" content="Relty ativades físicas e aventuras" />
        <link rel="icon" href="/assets/icon.png" />
      </Head>

      <Content>
        <Container>
          <ContainerText>
            <Container>
              <Text fontSize={24} fontWeight={600}>
                Veja seus resultados
              </Text>
            </Container>
          </ContainerText>
        </Container>

        <Row>
          <Column>
            <Text fontSize={18} fontWeight={600}>
              {/* @ts-ignore */}
              {overview?.receitaTotal?.toLocaleString("pt-BR", {
                minimumFractionDigits: 2,
                style: "currency",
                currency: "BRL",
              }) || "-"}{" "}
            </Text>
            <div> Sua receita total até o momento </div>
          </Column>

          <Column>
            <Text style={{ margin: "1rem" }}> Seu desempenho por período </Text>
            <Row col={1} style={{ padding: "0" }}>
              <InputGroup inputs={3} style={{ alignItems: "center" }}>
                {/* @ts-ignore */}
                <Input
                  type="date"
                  defaultValue={dateInputs.dataInicial}
                  onChange={(i) =>
                    setDateInputs((prevState) => {
                      return { ...prevState, dataInicial: i.target.value };
                    })
                  }
                />
                {/* @ts-ignore */}
                <Input
                  style={{ resize: "none" }}
                  type="date"
                  defaultValue={dateInputs.dataFinal}
                  onChange={(i) =>
                    setDateInputs((prevState) => {
                      return { ...prevState, dataFinal: i.target.value };
                    })
                  }
                />

                <div>
                  <FaSearch size={22} onClick={() => getDataOverviewDto(dateInputs)} style={{ cursor: "pointer" }} />
                </div>
              </InputGroup>
            </Row>
          </Column>

          <Column>
            <Text fontSize={18} fontWeight={600}>
              {/* @ts-ignore */}
              {overview?.receitaNoPeriodo?.toLocaleString("pt-BR", {
                minimumFractionDigits: 2,
                style: "currency",
                currency: "BRL",
              }) || "-"}{" "}
            </Text>
            <div> Receita no periodo </div>
          </Column>

          <Column>
            <Text fontSize={18} fontWeight={600}>
              {/* @ts-ignore */}
              {overview?.vendasNoPeriodo || "-"}{" "}
            </Text>
            <div> Aventuras vendidas no periodo </div>
          </Column>
        </Row>

        <Row>
          <Column>
            <Text fontSize={24} fontWeight={600}>
              Aventurar mais vendida
            </Text>
            {/* @ts-ignore */}
            {overview?.aventuraMaisVendida ? (
              //@ts-ignore
              <CardAdventure adventure={overview.aventuraMaisVendida} />
            ) : (
              <NoData>
                <p>Nenhum resultado encontrado</p>
              </NoData>
            )}
          </Column>

          <Column>
            <Text fontSize={24} fontWeight={600}>
              Aventurar mais favorita
            </Text>
            {/* @ts-ignore */}
            {overview?.aventuraMaisFavoritada?.id ? (
              //@ts-ignore
              <CardAdventure adventure={overview.aventuraMaisFavoritada} />
            ) : (
              <NoData>
                <p>Nenhum resultado encontrado</p>
              </NoData>
            )}
          </Column>

          <Column>
            <Text fontSize={24} fontWeight={600}>
              Aventurar melhor avaliada
            </Text>
            {/* @ts-ignore */}
            {overview?.aventuraMelhorAvaliada?.id ? (
              //@ts-ignore
              <CardAdventure adventure={overview.aventuraMelhorAvaliada} />
            ) : (
              <NoData>
                <p>Nenhum resultado encontrado</p>
              </NoData>
            )}
          </Column>
        </Row>
      </Content>
    </>
  );
};

export default Overview;

export const getServerSideProps: GetServerSideProps<any> = async (ctx) => {
  const { resolvedUrl } = ctx;
  let language = parseCookies(ctx).language || "pt";

  if (ctx.locale != language && language) {
    return Util.redirectToSelectedLanguage(ctx, resolvedUrl);
  }

  return {
    props: {
      ...(await serverSideTranslations(ctx.locale as string, ["common"])),
    },
  };
};
