import { transparentize } from "polished";
import styled from "styled-components";

export const Wrapper = styled.div`
  display: flex;
  width: 100%;
  max-width: 800px;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  margin: auto;

  padding: 10px 10px;
  box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
  border-radius: ${(p) => p.theme.borderRadius};
  background-color: ${(p) => p.theme.activeElementBackground};
  position: relative;

  form {
    max-width: 700px;
    width: 100%;
    padding: 5px;
  }
`;

export const InputGroup = styled.div<{ inputs: number }>`
  display: grid;
  width: 100%;
  justify-content: center;
  flex-wrap: wrap;
  gap: 10px;

  @media screen and (min-width: 768px) {
    grid-template-columns: repeat(${(p) => p.inputs || 1}, 1fr);
  }

  @media screen and (max-width: 768px) {
    display: flex;
    justify-content: center;
    align-items: center;
  }
`;

export const InputContainer = styled.div`
  width: 100%;
  display: flex;
  justify-content: flex-start;
`;


export const ButtonContainer = styled.div`
  width: 100%;
  display: flex;
  margin-top: 20px;
  justify-content: center;
  align-items: center;

  button{
    margin: 10px
  }
`;

export const ContainerText = styled.div`
  display: flex;
  flex-direction: row;
  width: 100%;
  justify-content: center;
`;

export const Title = styled.text`
  font: normal normal 600 24px/18px Poppins;
  margin: 20px 0;
`;

export const Text = styled.text<{ fontSize?: number }>`
  font: normal normal 600 ${(p) => p.fontSize || 16}px Poppins;
  margin: 20px 0;
  text-align: center;
`;

export const MapContainer = styled.div`
  width: 100%;
  height: 300px;
  margin-bottom: 1rem;
  border-radius: ${(p) => p.theme.borderRadius};
  box-shadow: 0 3px 10px ${(p) => transparentize(0.7, p.theme.pageForeground)};

  @media screen and (max-width: 767px) {
    height: 300px;
  }
`;