import Head from "next/dist/shared/lib/head";
import { GetServerSideProps } from "next";
import { Util } from "../../../../core/utils/util";
import { parseCookies } from "nookies";
import { serverSideTranslations } from "next-i18next/serverSideTranslations";
import Content from '../../../../app/components/Content'
import { Column, Container, ContainerText, Text, Row, InputGroup, NoData } from './styles'
import { useCallback, useEffect, useState } from "react"
import useEstablishment from "../../../../core/hooks/useEstablishment";
import { Input } from "../../../../app/components/CustomInput/styles";
import Link from "next/link";
import Button from "../../../../app/components/Button";
import { FaSearch } from 'react-icons/fa'
import Earth from "../../../../app/components/SvgIcons/earth";
import Water from "../../../../app/components/SvgIcons/water";
import Air from "../../../../app/components/SvgIcons/air";


export default function Overview() {
    const { getDataOverviewAdmin } = useEstablishment();
    const [overview, setOverview] = useState<any>({});
    const [dateInputs, setDateInputs] = useState({
        dataInicial: new Date(new Date().getFullYear(), new Date().getMonth() -1).toLocaleDateString('pt-br').split('/').reverse().join('-'),
        dataFinal: new Date().toLocaleDateString('pt-br').split('/').reverse().join('-')
    })

    const getDataOverviewAdminDto = useCallback(async (dateInputs) => {
        const response = await getDataOverviewAdmin(dateInputs);
        setOverview(response.data);
    }, []);

    useEffect(() => {
        getDataOverviewAdminDto(dateInputs)
    }, [getDataOverviewAdminDto])


    return (
        <>
        <Head>
            <title>Relty - Minhas aventuras</title>
            <meta name="description" content="Relty ativades físicas e aventuras" />
            <link rel="icon" href="/assets/icon.png" />
        </Head>
        
        <Content>
            <Container>
                <ContainerText>
                    <Container>
                        <Text fontSize={24} fontWeight={600}>Veja seus resultados pelo período selecionado</Text>
                    </Container>
                </ContainerText>
            </Container>

            <Link href="/profiles/admin/overview">
                <div>
                    <Button text={"Resultados gerais"}></Button>
                </div>
            </Link>
            
            <Row>

                <Column>
                {/* @ts-ignore */}
                    <Text fontSize={18} fontWeight={600}> { overview?.receitaTotal?.toLocaleString('pt-BR', { minimumFractionDigits: 2 , style: 'currency', currency: 'BRL' }) || '-' } </Text>
                    <Text fontSize={16}> Receita pelo período selecionado </Text>        
                </Column>

                <Column>
                    <Text style={{ margin: '1rem' }}> Selecione o período </Text>
                    <Row col={1} style={{ padding: '0' }}>
                    <InputGroup inputs={3} style={{ alignItems: 'center' }} >
                        {/* @ts-ignore */}
                        <Input
                            style={{ resize: 'none' }}
                            type="date"
                            defaultValue={dateInputs.dataInicial}
                            onChange={i => setDateInputs(prevState => {
                                return { ...prevState, dataInicial: i.target.value }
                            })}
                        />
                        {/* @ts-ignore */}
                        <Input
                            style={{ resize: 'none' }}
                            type="date"
                            defaultValue={dateInputs.dataFinal}
                            onChange={(i) => setDateInputs(prevState => {
                                return { ...prevState, dataFinal: i.target.value }
                            })}
                        />

                        <div>
                            <FaSearch size={22} onClick={() => getDataOverviewAdminDto(dateInputs)} style={{ cursor: 'pointer' }}/>
                        </div>
                    </InputGroup>
                    </Row>
                </Column>

                <Column>
                {/* @ts-ignore */}
                    <Text fontSize={16} fontWeight={600}> { overview?.ticketMedio?.toLocaleString('pt-BR', { minimumFractionDigits: 2 , style: 'currency', currency: 'BRL' }) || '-' } </Text>
                    <Text fontSize={18}> Ticket médio </Text> 
                </Column>

                <Column>
                {/* @ts-ignore */}
                    <Text fontSize={18} fontWeight={600}> { overview?.aventurasRealizadas || '-' } </Text>
                    <Text fontSize={16}> Aventuras realizadas </Text> 
                </Column>

                <Column>
                {/* @ts-ignore */}
                    <Text fontSize={18} fontWeight={600}> { overview?.totalAventurasNoPeriodo || '-' } </Text>
                    <Text fontSize={16}> Aventuras cadastradas </Text>
                </Column>

                <Column>
                    <Container>
                        {   overview?.tipoMaisVendido?.includes("T") ? (<Earth width={50} height={50} active={true} />) : 
                            overview?.tipoMaisVendido?.includes("A") ? (<Air width={50} height={50} active={true} />) : 
                            overview?.tipoMaisVendido?.includes("G") ? (<Water width={50} height={50} active={true} />) : '-' }
                    </Container>
                    <Text fontSize={16}> Elemento mais vendido </Text>
                </Column>
            </Row>
        </Content>
        </>
    )
};


export const getServerSideProps: GetServerSideProps<any> = async (ctx) => {
    const { resolvedUrl } = ctx;
    let language = parseCookies(ctx).language || "pt";

    if (ctx.locale != language && language) {
        return Util.redirectToSelectedLanguage(ctx, resolvedUrl);
    }

    return {
        props: {
            ...(await serverSideTranslations(ctx.locale as string, ["common"])),
        }
    }
}