import Head from "next/dist/shared/lib/head";
import { GetServerSideProps } from "next";
import { Util } from "../../../../core/utils/util";
import { parseCookies } from "nookies";
import { serverSideTranslations } from "next-i18next/serverSideTranslations";
import Content from '../../../../app/components/Content'
import { Column, Container, ContainerText, Text, Row, NoData, ImageAndNameContainer, RateImage, TextContainer, SupplierName, Stars } from './styles'
import { useCallback, useEffect, useState } from "react"
import useEstablishment from "../../../../core/hooks/useEstablishment";
import CardAdventure from "../../../../app/components/CardAdventure";
import Link from "next/link";
import Button from "../../../../app/components/Button";
import Star from '../../../../app/components/SvgIcons/star'
import Earth from '../../../../app/components/SvgIcons/earth'
import Air from "../../../../app/components/SvgIcons/air";
import Water from "../../../../app/components/SvgIcons/water";
import { FaAndroid, FaApple } from 'react-icons/fa'


const Overview = () => {
    const { getDataOverviewAdmin } = useEstablishment();
    const [overview, setOverview] = useState<any>({});
    const [dateInputs, setDateInputs] = useState({
        dataInicial: new Date(new Date().getFullYear(), new Date().getMonth() -1).toLocaleDateString('pt-br').split('/').reverse().join('-'),
        dataFinal: new Date().toLocaleDateString('pt-br').split('/').reverse().join('-')
    })

    const getDataOverviewAdminDto = useCallback(async (dateInputs) => {
        const response = await getDataOverviewAdmin(dateInputs);
        setOverview(response.data);
    }, []);
    
    useEffect(() => {
        getDataOverviewAdminDto(dateInputs)
    }, [getDataOverviewAdminDto])


    return (
        <>
        <Head>
            <title>Relty - Minhas aventuras</title>
            <meta name="description" content="Relty ativades físicas e aventuras" />
            <link rel="icon" href="/assets/icon.png" />
        </Head>
        
        <Content>
            <Container>
                <ContainerText>
                    <Container>
                        <Text fontSize={24} fontWeight={600}>Veja seus resultados</Text>
                    </Container>
                </ContainerText>
            </Container>

            <Link href="/profiles/admin/overview/timecourse">
                <div>
                    <Button text={"Filtrar por período"}></Button>
                </div>
            </Link>
            <br/>

            <Column>
            {/* @ts-ignore */}
                <Text fontSize={18} fontWeight={600}> { overview?.receitaTotal?.toLocaleString('pt-BR', { minimumFractionDigits: 2 , style: 'currency', currency: 'BRL' }) || '-' } </Text>
                <div> Sua receita total até o momento </div>
            </Column>

            <Row>
                <Column>
                {/* @ts-ignore */}
                    <Text fontSize={18} fontWeight={600}> { overview?.ticketMedio?.toLocaleString('pt-BR', { minimumFractionDigits: 2 , style: 'currency', currency: 'BRL' }) || '-' } </Text>
                    <div> Ticket médio </div>
                </Column>

                <Column>
                {/* @ts-ignore */}
                    <Text fontSize={18} fontWeight={600}> { overview?.aventurasRealizadas || '-' } </Text>
                    <div> Aventuras realizadas </div>
                </Column>
            </Row>

            <Row>
                <Column style={{ height: '24.8rem', overflowY: 'scroll' }}>
                    <Text fontSize={24} fontWeight={600}>Fornecedores melhor avaliados</Text>
                    {/* @ts-ignore */}
                    { overview?.estabelecimentoMelhorAvaliado?.map((supplier, index) => (
                        <ImageAndNameContainer key={index}>
                                <RateImage url={supplier?.urlFoto}/>
                                <TextContainer>
                                    <Stars>
                                        <Star/> { supplier?.avaliacaoMedia || 0 }
                                    </Stars>
                                    <SupplierName> { supplier?.estabelecimento?.pessoa?.nome || 'Sem nome' } </SupplierName>
                                </TextContainer>
                        </ImageAndNameContainer>
                    )) }
{/* @ts-ignore */}
                    { !overview?.estabelecimentoMelhorAvaliado && (
                        <NoData>
                            <p>Nenhum resultado encontrado</p>
                        </NoData>
                    )}

                </Column>

                <Column>
                <Text fontSize={24} fontWeight={600}>Aventura mais vendida</Text>
                {/* @ts-ignore */}
                {overview?.aventuraMaisVendida ? (
                    <CardAdventure adventure={overview?.aventuraMaisVendida}/>
                ) : (
                    <NoData>
                        <p>Nenhum resultado encontrado</p>
                    </NoData>
                )}
                </Column>
            </Row>

            <Row>
                <Column>
                {/* @ts-ignore */}
                    <Text fontSize={18} fontWeight={600}> { overview?.totalAventuras || '-' } </Text>
                    <div> Aventuras cadastradas </div>
                </Column>

                <Column>
                    <Container>
                        {   overview?.tipoMaisVendido?.includes("T") ? (<Earth width={50} height={50} active={true} />) : 
                            overview?.tipoMaisVendido?.includes("A") ? (<Air width={50} height={50} active={true} />) : 
                            overview?.tipoMaisVendido?.includes("G") ? (<Water width={50} height={50} active={true} />) : '-' }
                    </Container>
                    <div> Elemento mais vendido </div>
                </Column>
            </Row>

            <Row>
                <Column>
                    <Text fontSize={18} fontWeight={600}> { overview?.usuariosAtivos || '-' } </Text>
                    <div> Total de usuários ativos </div>
                </Column>

                <Column>
                    <Text fontSize={18} fontWeight={600}> { overview?.usuariosInativos || '-' } </Text>
                    <div> Total de usuários inativos </div>
                </Column>

            </Row>

            <Row>
                <Column>
                    <Text fontSize={24} fontWeight={600}>Usuários ativos por plataforma</Text>
                    <Row style={{ margin: 0 }}>
                        <ContainerText>
                            <Text fontSize={24} fontWeight={600}>
                                <FaAndroid size={24} />
                            </Text>
                            <Text fontSize={24} fontWeight={600}> { overview?.downloadAtivoAndroid || '-' } </Text>
                        </ContainerText>
                        
                        <ContainerText>
                            <Text fontSize={24} fontWeight={600}>
                                <FaApple size={24} />
                            </Text>
                            <Text fontSize={24} fontWeight={600}> { overview?.downloadAtivoIos || '-' } </Text>
                        </ContainerText>
                    </Row>
                </Column>

                <Column>
                    <Text fontSize={24} fontWeight={600}>Usuários inativos por plataforma</Text>
                    <Row style={{ margin: 0 }}>
                        <ContainerText>
                            <Text fontSize={24} fontWeight={600}>
                                <FaAndroid size={24} />
                            </Text>
                            <Text fontSize={24} fontWeight={600}> { overview?.downloadInativoAndroid || '-' } </Text>
                        </ContainerText>
                        
                        <ContainerText>
                            <Text fontSize={24} fontWeight={600}>
                                <FaApple size={24} />
                            </Text>
                            <Text fontSize={24} fontWeight={600}> { overview?.downloadInativoIos || '-' } </Text>
                        </ContainerText>
                    </Row>
                </Column>
            </Row>

        </Content>
        </>
    )
};

export default Overview;


export const getServerSideProps: GetServerSideProps<any> = async (ctx) => {
    const { resolvedUrl } = ctx;
    let language = parseCookies(ctx).language || "pt";

    if (ctx.locale != language && language) {
        return Util.redirectToSelectedLanguage(ctx, resolvedUrl);
    }

    return {
        props: {
            ...(await serverSideTranslations(ctx.locale as string, ["common"])),
        }
    }
}