import { transparentize } from "polished";
import styled from "styled-components";

export const Wrapper = styled.div`
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    padding: 10px 10px;
    box-shadow: 0 3px 10px ${(p) => transparentize(0.9, p.theme.pageForeground)};
    border-radius: ${(p) => p.theme.borderRadius};
    background-color: ${(p) => p.theme.activeElementBackground};
`;

export const Title = styled.text`
    font: normal normal 600 24px/18px Poppins;
    margin: 20px 0;
`;

export const SearchContainer = styled.div`
    padding: 0 16px;
    width: 100%;

    @media screen and (max-width: 767px) {
        padding: 0 0;
        margin: 20px;
    }
`;

export const Elements = styled.div`
    height: 100%;
    display: flex;
    flex-direction: row;
    gap: 10px;
`;

export const InputWrapper = styled(Elements)`
    width: 50%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
    a {
        text {
        color: ${(p) => p.theme.primaryBackground};
        }
    }
    @media screen and (max-width: 767px) {
        width: 100%;
    }
`;
export const ButtonContainer = styled.div`
    width: 30%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
    
        a {
        text {
            color: ${(p) => p.theme.primaryBackground};
        }
    }
`;