import { GetServerSideProps } from "next";
import Head from "next/head";
import { Util } from "../../core/utils/util";
import { parseCookies } from "nookies";
import { serverSideTranslations } from "next-i18next/serverSideTranslations";
import CardAdventureCommunity from "../../app/components/CardAdventureCommunity";
import useAdventure from "../../core/hooks/useAdventure";
import { useCallback, useEffect, useState } from "react";
import { Pagination } from "../../core/models/interfaces/Pagination";
import { CardsGrid, NoData, CardContainer } from './styles'
import { useTranslation } from "next-i18next";
import ReactPaginate from "react-paginate";

export default function Community(props: any) {

    const { getCommunityAdventures } = useAdventure()
    const { t } = useTranslation()
    const [queryPage, setQueryPage] = useState({ page: 0, size: 10 });
    const [dataContent, setDataContent] = useState<Pagination>({} as Pagination);
    const [mudarSeSeguindo, setMudarSeSeguindo] = useState(0);

    const getCommunityAdventuresDto = useCallback(async (queryPage) => {
        const response = await getCommunityAdventures(queryPage)
        setDataContent(response.data)
    }, [])

    const seguirCardsIguais = (id: any) => {
        for (let index = 0; index < dataContent.content.length; index++) {
            if (dataContent.content[index].idCliente == id) {
                dataContent.content[index].seSeguindo = "S";
            }
        }
        setDataContent(dataContent);
        setMudarSeSeguindo(mudarSeSeguindo + 1);
    }

    const naoSeguirCardsIguais = (id: any) => {
        for (let index = 0; index < dataContent.content.length; index++) {
            if (dataContent.content[index].idCliente == id) {
                dataContent.content[index].seSeguindo = "N";
            }
        }
        setDataContent(dataContent);
        setMudarSeSeguindo(mudarSeSeguindo + 1);
    }

    useEffect(() => {
        getCommunityAdventuresDto(queryPage);
    }, []);

    return (
        <div>
            <Head>
                <title>Relty - Comunidade</title>
            </Head>

            {dataContent.content && dataContent.content.length > 0 ? (
            <>
                <CardsGrid>
                    {dataContent?.content.map((item: any) => (
                    <CardContainer key={item.id}>
                        <CardAdventureCommunity adventure={item} mudarSeguindo={mudarSeSeguindo} naoSeguirCardsIguais={naoSeguirCardsIguais} seguirCardsIguais={seguirCardsIguais}/>
                    </CardContainer>
                    ))}
                </CardsGrid>

                <ReactPaginate
                    forcePage={queryPage.page - 1}
                    data-content="My Content"
                    containerClassName={"Pagination"}
                    pageCount={dataContent?.totalPages ? dataContent?.totalPages : 0}
                    marginPagesDisplayed={0}
                    pageRangeDisplayed={3}
                    previousLabel={"<"}
                    nextLabel={">"}
                    onPageChange={(page) => getCommunityAdventuresDto({ page: page.selected, size: queryPage.size })}
                />
            </>
            ) : (
                <NoData>
                    <h2>{t("noResults")}</h2>
                </NoData>
            )}
            <br/>
        </div>
    );
};

export const getServerSideProps: GetServerSideProps<any> = async (ctx) => {
    const { query, resolvedUrl } = ctx;
    const { page: _page } = query;

    let language = parseCookies(ctx).language || "pt";
    if (ctx.locale != language && language) {
        return Util.redirectToSelectedLanguage(ctx, resolvedUrl);
    }

return {
        props: {
            ...(await serverSideTranslations(ctx.locale as string, ["common"])),
        },
    };
};
