import styled from "styled-components";

export const CardContainer = styled.a`
  margin: 22px 0 22px 0;
  cursor: pointer;
  min-width: 300px;
  height: 400px;

  @media screen and (max-width: 767px) {
    width: 100%;
  }
`;

export const CardsGrid = styled.div`
  width: 100%;
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  margin: auto;
  gap: 10px;
`;

export const NoData = styled.div`
  margin: auto;
  margin-top: 50px;

  h2 {
    text-align: center;
  }
`;

export const SearchContainer = styled.div`
  padding: 0 16px;
  width: 100%;

  @media screen and (max-width: 767px) {
    padding: 0 0;
  }
`;

export const TextFont = styled.text<{ fontSize?: number, fontWeight?: number }>`
    font: normal normal ${(p) => p.fontWeight || 'normal'} ${(p) => p.fontSize || 16}px Poppins;
    margin: 20px 0;
    text-align: center;
`;

export const ContainerText = styled.div`
    flex-direction: column;
    width: 100%;
    justify-content: center;
    display: grid;
`;