import "../styles/globals.css";
import type { AppProps } from "next/app";
import { ThemeProvider } from "styled-components";
import { light } from "../styles/theme";
import GlobaStyles from "../styles/globaStyles";
import Header from "../app/components/Header";
import Footer from "../app/components/Footer";
import Content from "../app/components/Content";
import Head from "next/head";
import { UserProvider } from "../core/contexts/UserContext";
import ProgressBar from "@badrap/bar-of-progress";
import VLibras from "@djpfs/react-vlibras";

//Prime
import "primereact/resources/themes/saga-blue/theme.css";
import "primereact/resources/primereact.min.css";
import "primeicons/primeicons.css";
import "primeflex/primeflex.css";

import { IntlProvider } from "react-intl";
import { GeolocationProvider } from "../core/contexts/GeolocationContext";
import { PreferencesProvider } from "../core/contexts/PreferencesContext";
import { useEffect } from "react";
import useOneSignal from "../core/hooks/useOneSignal";

import { useTranslation } from "next-i18next";

import { appWithTranslation } from "next-i18next";
import nextI18NextConfig from "../../next-i18next.config.js";
import { Router } from "next/router";
import "react-dropdown/style.css";

const progress = new ProgressBar({
  size: 3,
  color: light.primaryBackground,
  delay: 100,
});

function MyApp({ Component, pageProps }: AppProps) {
  const { initOneSignal } = useOneSignal();
  const { i18n } = useTranslation("common");

  useEffect(() => {
    initOneSignal();
  }, []);

  return (
    <IntlProvider messages={require("../../public/locales/pt/common.json")} locale="pt-BR" defaultLocale="pt-BR">
      <ThemeProvider theme={light}>
        <PreferencesProvider>
          <UserProvider>
            <GeolocationProvider>
              <>
                <Head>
                  <meta name="theme-color" content={light.primaryBackground}></meta>
                  <meta
                    name="viewport"
                    content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"
                  />
                  <link rel="shortcut icon" href="/assets/icon.png" />
                </Head>
                <GlobaStyles />
                <Header />
                <VLibras />
                <Content>
                  {/* @ts-ignore */}
                  <Component {...pageProps} />
                </Content>
                <Footer />
              </>
            </GeolocationProvider>
          </UserProvider>
        </PreferencesProvider>
      </ThemeProvider>
    </IntlProvider>
  );
}

Router.events.on("routeChangeStart", progress.start);
Router.events.on("routeChangeComplete", progress.finish);
Router.events.on("routeChangeError", progress.finish);

export default appWithTranslation(MyApp, nextI18NextConfig);
