import { mask, unMask } from "remask";

export const masks = {
  cpfCnpj,
  brCellphone,
  brMoney,
  cep
};

function cpfCnpj(documentValue?: string): string {
  documentValue = unMask(documentValue);

  return mask(documentValue, ["999.999.999-99", "99.999.999/9999-99"]);
}

function brCellphone(documentValue?: string): string {
  documentValue = unMask(documentValue);

  return mask(documentValue, ["(99)9 9999-9999"]);
}

function brMoney(documentValue?: string): string {
  documentValue = unMask(documentValue);

  return mask(documentValue, ["(99)9 9999-9999"]);
}

function cep(documentValue?: string): string {
  documentValue = unMask(documentValue);

  return mask(documentValue, ["99999-999"]);
}