import axios from "axios";
import qs from "qs";
import { setCookie, parseCookies, destroyCookie } from "nookies";

export const baseURL = "https://reltyapp.com.br/api";//process.env.NEXT_PUBLIC_API;
console.log('apiServerSide ==>', baseURL)
export const tokenConfig = {
  headers: {
    Authorization: "Basic QVBQOjRQUA==",
    "Content-Type": "application/x-www-form-urlencoded",
  },
};

export function getApi(ctx?: any) {
  const instance = axios.create({
    baseURL: baseURL,
    headers: {
      "Content-Type": "application/json;charset=UTF-8",
    },
  });

  instance.interceptors.request.use(
    function (config) {
      const access_token = getToken(ctx);
      if (access_token) {
        config.headers = {
          "Content-Type": "application/json;charset=UTF-8",
          Authorization: "Bearer " + access_token,
        };
      }
      return config;
    },
    function (error) {
      // Faça algo com erro da solicitação
      return Promise.reject(error);
    }
  );

  instance.interceptors.response.use(
    (response) => {
      return response;
    },
    async function (error) {
      const access_token = getToken(ctx);
      if (error.response?.status === 401 && access_token) {
        await refreshToken(error);
        const newToken = getToken(ctx);

        if (newToken) {
          error.config.headers = {
            "Content-Type": "application/json;charset=UTF-8",
            Authorization: "Bearer " + newToken,
          };
          return Promise.resolve(axios.request(error.config));
        }
      }
      return Promise.reject(error);
    }
  );

  return instance;
}

async function refreshToken(error: any) {
  return new Promise((resolve, reject) => {
    try {
      const refresh_token = getRefreshToken();

      let url = "/oauth/token";
      let body = {
        client: "NAVEGADOR",
        refresh_token: refresh_token,
        grant_type: "refresh_token",
      };

      axios
        .post(baseURL + url, qs.stringify(body), tokenConfig)
        .then(async (res) => {
          setCookie(undefined, "access_token", res.data.access_token, { path: "/", maxAge: 30 * 24 * 60 * 60 * 2 });
          setCookie(undefined, "refresh_token", res.data.refresh_token, { path: "/", maxAge: 30 * 24 * 60 * 60 * 2 });
          return resolve(res);
        })
        .catch((err) => {
          console.log(err);
          cleanSession();
          return reject(error);
        });
    } catch (err) {
      return reject(err);
    }
  });
}

function getToken(ctx?: any) {
  let token = parseCookies(ctx).access_token;
  if (token) {
    try {
      return JSON.parse(token);
    } catch (error) {
      return token;
    }
  }
}

function getRefreshToken(ctx?: any) {
  let refreshToken = parseCookies(ctx).refresh_token;

  if (refreshToken) {
    try {
      return JSON.parse(refreshToken);
    } catch (error) {
      return refreshToken;
    }
  }
}

export function cleanSession() {
  destroyCookie(undefined, "user", { path: "/" });
  destroyCookie(undefined, "refresh_token", { path: "/" });
  destroyCookie(undefined, "access_token", { path: "/" });
}
