import api from "./api";
import { AdventureListDto } from "../models/interfaces/Adventure/AdventureListDto";
import { AdventureDetailsDto } from "../models/interfaces/Adventure/AdventureDetailsDto";
import { AxiosResponse } from "axios";
import { Pagination } from "../models/interfaces/Pagination";
import { getApi } from "./apiServerSide";

const filterAdventure = async (
  page = 0
): Promise<AxiosResponse<Pagination<AdventureListDto[]>>> => {
  return await api.post(`/WS/Aventura/Filtrar?page=${page}&size=12`, {});
};

const getAdventureCompleteById = async (
  id: number
): Promise<AdventureDetailsDto> => {
  let adventures = await api.get(`/WS/Aventura/Completa/${id}`);
  return adventures.data as AdventureDetailsDto;
};

const favoriteAdventure = async (id: number): Promise<AxiosResponse<void>> => {
  return await api.post(`/WS/Aventura/${id}/Favoritar`);
};

const desfavoriteAdventure = async (id: number): Promise<AxiosResponse<void>> => {
  return await api.post(`/WS/Aventura/${id}/Desfavoritar`);
};

const AdventureService = {
  filterAdventure,
  getAdventureCompleteById,
  favoriteAdventure,
  desfavoriteAdventure,
};

export default AdventureService;
