export interface Places {
  predictions?: Prediction[];
}

export interface Prediction {
  description: string;
  place_id: string;
  structured_formatting: StructuredFormatting;
  favorito: boolean;
}

export interface StructuredFormatting {
  main_text: string;
  secondary_text: string;
}

export interface Location {
  lat: number;
  lng: number;
}

export interface Northeast {
  lat: number;
  lng: number;
}

export interface Southwest {
  lat: number;
  lng: number;
}

export interface Viewport {
  northeast: Northeast;
  southwest: Southwest;
}

export interface Geometry {
  location: Location;
  viewport: Viewport;
}

export interface Result {
  geometry: Geometry;
  name: string;
  place_id: string;
}

export interface PlaceDetailResponse {
  html_attributions: any[];
  result: Result;
  status: string;
}
