import { Base } from '../Base';
import { EstablishmentDto } from '../Establishment/EstablishmentDto';
import { ImageDto } from '../Image/imageDto';
import { Material } from '../Material/Material';
import { AdventureLevel } from '../../enums/AdventureLevel';
import { AdventureType } from '../../enums/AdventureType';

export interface AdventureDetailsDto extends Base {
  descricao: string;
  imagens: ImageDto[];
  materiaisInclusos: Material[];
  materiaisObrigatorios: Material[];
  estabelecimento: EstablishmentDto;
  latitude: number;
  longitude: number;
  totalAvaliacoes: number;
  enderecoFormatado: string;
  tipoDuracao: string;
  tipoPercurso: string;
  disponivelParaVenda: string;
  quantidadeParcela: number;
  slug: string;
  seFavorito: string;
  titulo: string;
  local: string;
  preco: number;
  nivel: AdventureLevel;
  percurso: number;
  duracao: string;
  tipo: AdventureType;
  mediaAvaliacao: number;
}
