import OneSignal from "react-onesignal";
import { useUserContext } from "../contexts/UserContext";
import { ONESIGNAL_KEY } from "../utils/keys";
import useUser from "./useUser";

export default function useOneSignal() {
  const { updateOneSignalToken } = useUser();

  const initOneSignal = async () => {
    {/* @ts-ignore */}
    await OneSignal.init({
      appId: process.env.NEXT_PUBLIC_ONESIGNAL_ID,
      safari_web_id: process.env.NEXT_PUBLIC_ONESIGNAL_SAFARI_ID,
      allowLocalhostAsSecureOrigin: true,
    }).then(() => {
      registerUserForNotifications();
    });
  };

  const registerUserForNotifications = () => {
    OneSignal.registerForPushNotifications()
      .then(() => {
        OneSignal.getUserId((userId: any) => {
          if (userId) {
            updateOneSignalToken(userId);
          }
        });
      })
      .catch((error: any) => {
        console.log(error);
      });
  };

  return {
    initOneSignal,
  };
}
