import { AxiosResponse } from "axios";
import api from "../services/api";

export default function useMaterial() {
    const getDataMaterial = async (filtro: any, query?: any): Promise<AxiosResponse<any>> => {
        return await api.post(`/WS/Material/Listagem/Filtrar`, filtro, {
            params: {
                page: query?.page,
                size: query?.size,
                sortDirection: 'ASC',
                sortField: 'descricao'
            }
        })
    }

    const saveDataMaterial = async (material: any): Promise<AxiosResponse<any>> => {
        return await api.post(`/WS/Material`, material);
    }

    const deleteDataMaterial = async (material: any): Promise<AxiosResponse<any>> => {
        return await api.delete(`/WS/Material/${material.id}`);
    }

    return {
        getDataMaterial,
        saveDataMaterial,
        deleteDataMaterial
    };
}
