import { ChangeEvent, useState } from "react";
import { ImageError } from "../utils/exceptions";
import { File } from "../models/interfaces/Image/File";

export default function useFile(archiveAccepted: string) {
  const [archiveInfos, setArchiveInfos] = useState<File>();

  const getArchiveByHtmlInput = (event: ChangeEvent<HTMLInputElement>) => {
    if (!event || !event.target || !event.target?.files || !event.target?.files[0]) {
      throw new ImageError("Houve um problema em formatar o arquivo");
    }

    const archive = event.target.files[0];
    const reader = new FileReader();
    const TAMANHO_MAX_ARQUIVO = 12000;
    const tamanhoArquivo = archive.size / 1024;
    const typeArchive = archive.type.split("/");
    const archiveUri = window.URL.createObjectURL(event.target.files[0]);

    if (typeArchive[0] != archiveAccepted) {
      throw new ImageError("Tipo de arquivo inválido");
    }

    if (tamanhoArquivo > TAMANHO_MAX_ARQUIVO) {
      throw new ImageError("Tamanho do arquivo excedido!");
    }

    reader.readAsDataURL(archive);

    reader.onload = (formatedArchive: ProgressEvent<FileReader>) => {
      if (formatedArchive.target?.result) {
        var base64 = formatedArchive?.target?.result.toString().split("base64,");

        setArchiveInfos({
          base64: base64[1],
          uri: archiveUri,
          tamanho: tamanhoArquivo,
          nome: archive.name,
          contentType: archive.type,
        });
      }
    };

    reader.onerror = () => {
      throw new ImageError("Houve um erro ao ler o arquivo");
    };
  };

  return { getArchiveByHtmlInput, archiveInfos };
}
