import { AxiosResponse } from "axios";
import { useUserContext } from "../contexts/UserContext";
import { User } from "../models/interfaces/User/User";
import { UserEditDto } from "../models/interfaces/User/UserEditDto";
import api from "../services/api";

export default function useEstablishment() {
  const { user } = useUserContext();

  const getDataEditing = async (): Promise<AxiosResponse<UserEditDto>> => {
    return await api.get(`/WS/UsuarioRelty/${user.id}/Dto/Estabelecimento`);
  };

  const saveDataEditing = async (userEditDto: UserEditDto): Promise<AxiosResponse<User>> => {
    return await api.post(`/WS/UsuarioRelty/Editar`, userEditDto);
  };

  const getDataCategoria = async (): Promise<AxiosResponse<any>> => {
    return await api.get(`/WS/Categoria`,);
  };

  const getDataMaterial = async (): Promise<AxiosResponse<any>> => {
    return await api.get(`/WS/Material`,);
  };

  const getListTimeLocalStorage = () => {
    {/* @ts-ignore */}
    return JSON.parse(sessionStorage.getItem('horarios')) == null ? [] : JSON.parse(sessionStorage.getItem('horarios'))
  }

  const saveListTimeLocalStorage = (value: Array<object>) => {
    sessionStorage.setItem('horarios', JSON.stringify(value))
  }
  
  const getDataOverview = async (filtro: any): Promise<AxiosResponse<any>> => {
    return await api.post(`/WS/Estabelecimento/Overview`, filtro);
  };

  const getDataOverviewAdmin = async (filtro: any): Promise<AxiosResponse<any>> => {
    return await api.post(`/WS/UsuarioRelty/Admin/Overview`, filtro);
  };

  const getDataListFilter = async (filtro: any, query?: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/Estabelecimento/Listagem/Filtrar`, filtro, {
      params: {
        page: query?.page,
        size: query?.size,
        sortDirection: 'ASC'
      }
    })
  }

  const getDataListUserFilter = async (filtro: any, query?: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/UsuarioRelty/Listagem/Filtrar`, filtro, {
      params: {
        page: query?.page,
        size: query?.size,
        sortDirection: 'ASC',
        sortField: 'nome'
      }
    })
  }

  const getDataDetailSupplier = async (supplierId: any): Promise<AxiosResponse<any>> => {
    return await api.get(`WS/UsuarioRelty/Estabelecimento/${supplierId}/Dto/Estabelecimento`);
  };

  const saveSupplierComission = async (comission: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/Estabelecimento/AlterarPorcentagem`, comission)
  }

  return {
    getDataEditing,
    saveDataEditing,
    getDataCategoria,
    getDataMaterial,
    getListTimeLocalStorage,
    saveListTimeLocalStorage,
    getDataOverview,
    getDataListFilter,
    getDataListUserFilter,
    getDataOverviewAdmin,
    getDataDetailSupplier,
    saveSupplierComission
  }
}