import { AxiosResponse } from "axios";
import api from "../services/api";

export default function useClient() {

  const getDataListUserFilter = async (filtro: any, query?: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/ClienteEstabelecimento/Filtrar`, filtro)
  }

  const getDataUserDetails = async (clienteId: any): Promise<AxiosResponse<any>> => {
    return await api.get(`WS/Cliente/${clienteId}/Perfil`)
  }

  const getDataUserLastAdventure = async (): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/ClienteAventura/Aventura/Filtrar`)
  }

  const saveDataSubscribed = async (companion: any, newStatus: string): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/ClienteAventuraAcompanhante/AlterarPresenca/${companion.acompanhanteId}?novoStatus=${newStatus}`, {})
  }

  const saveDataCloseClasse = async (classeId: number): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/AventuraTurma/AlterarSituacao/${classeId}`, {})
  }
  
  const saveDataFollow = async (client: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/Cliente/${client.idCliente}/Seguir`, null)
  }

  const saveDataUnFollow = async (client: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/Cliente/${client.idCliente}/DeixarDeSeguir`, null)
  }

  const getDataAdress = async (clientId: number): Promise<AxiosResponse<any>> => {
    return await api.get(`WS/Cliente/Endereco/${clientId}`)
  }

  return {
    getDataListUserFilter,
    getDataUserDetails,
    getDataUserLastAdventure,
    saveDataSubscribed,
    saveDataCloseClasse,
    saveDataFollow,
    saveDataUnFollow,
    getDataAdress
  };
}