import { AxiosResponse } from "axios";
import api from "../services/api";

export default function useCategory() {
    const getDataCategory = async (filtro: any, query?: any): Promise<AxiosResponse<any>> => {
        return await api.post(`/WS/Categoria/Filtrar/Pageable`, filtro, {
            params: {
                page: query?.page,
                size: query?.size,
                sortDirection: 'ASC',
                sortField: 'nome'
            }
        })
    }

    const saveDataCategory = async (category: any): Promise<AxiosResponse<any>> => {
        return await api.post(`/WS/Categoria`, category);
    }

    const deleteDataCategory = async (category: any): Promise<AxiosResponse<any>> => {
        return await api.delete(`/WS/Categoria/${category.id}`);
    }

    return {
        getDataCategory,
        saveDataCategory,
        deleteDataCategory
    };
}
