import axios from "axios";
import { useUserContext } from "../contexts/UserContext";
import qs from "qs";
import { BadCredentialsException } from "../utils/exceptions";
import { setCookie } from "nookies";
import { baseURL, cleanSession, tokenConfig } from "../services/apiServerSide";
import router from "next/router";
import { UserRegisterDto } from "../models/interfaces/User/UserRegisterDto";
import { useTranslation } from "react-i18next";

export default function useAuth() {
  const userContext = useUserContext();
  const { t } = useTranslation("common");

  const login = async (email: string, password: string) => {
    let body = {
      client: "NAVEGADOR",
      username: email,
      password: password,
      grant_type: "password",
    };
    console.log('login =>', baseURL, 'body', body)
    await axios
      .post(baseURL + "/oauth/token", qs.stringify(body), tokenConfig)
      .then((result) => {
        console.log('result ==>', result)
        userContext.setUser(result.data);

        setCookie(undefined, "user", JSON.stringify(result.data), { path: "/", maxAge: 30 * 24 * 60 * 60 * 2 });
        setCookie(undefined, "access_token", JSON.stringify(result.data?.access_token), {
          path: "/",
          maxAge: 30 * 24 * 60 * 60 * 2,
        });
        setCookie(undefined, "refresh_token", JSON.stringify(result.data?.refresh_token), {
          path: "/",
          maxAge: 30 * 24 * 60 * 60 * 2,
        });
      })
      .catch((error) => {
        console.log('errorLogin ==>', error)
        console.log('errorLoginrequest ==>', baseURL + "/oauth/token", qs.stringify(body), tokenConfig)
        if (error.response && error.response.status == 400) {
          throw new BadCredentialsException(t("emailAndPasswordError"));
        } else {
          throw new Error(t("errorLogin"));
        }
      });
  };

  const recoverPassword = async () => {};

  const registerUser = async (user: UserRegisterDto) => {
    await axios
      .post(baseURL + "/WS/UsuarioRelty/Criar", user)
      .then(() => {
        login(user.email, user.senha);
      })
      .catch(() => {
        throw new Error(t("registrationError"));
      });
  };

  const logout = async () => {
    cleanSession();
    setTimeout(() => {
      router.replace("/home");
    }, 300);
  };

  return {
    login,
    recoverPassword,
    logout,
    registerUser,
  };
}
