import { AxiosResponse } from "axios";
import api from "../services/api";

export default function useAdventure() {
  const favoriteAdventure = async (id: number): Promise<AxiosResponse<void>> => {
    return await api.post(`/WS/Aventura/${id}/Favoritar`);
  };

  const desfavoriteAdventure = async (id: number): Promise<AxiosResponse<void>> => {
    return await api.post(`/WS/Aventura/${id}/Desfavoritar`);
  };

  const createAdventure = async ( body: object ): Promise<AxiosResponse<void>> => {
    return await api.post("/WS/Aventura", body);
  };
  
  const getSchedulesAdventures = async (adventureId: any): Promise<AxiosResponse<any>> => {
    return await api.get(`WS/Aventura/${adventureId}/Horarios`)
  }

  const getAdventuresTime = async (adventureId: any, dateFormat: string) => {
    return await api.get(`/WS/Aventura/${adventureId}/Horarios/${dateFormat}`)
  }

  const getListClasses = async (filtro: any, query: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/AventuraTurma/Filtrar/Pageable`, filtro, {
      params: {
        page: query?.page,
        size: query?.size,
        sortDirection: 'ASC'
      }
    })
  }

  const getListSubscribed = async (filtro: any, query: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/ClienteAventuraAcompanhante/Filtrar`, filtro, {
      params: {
        page: query?.page,
        size: query?.size,
        sortDirection: 'ASC'
      }
    })
  }
    
  
  const getCommunityAdventures = async (query?: any): Promise<AxiosResponse<any>> => {
    return await api.post(`WS/ClienteAventura/Comunidade/Pageable`, {}, {
      params: {
        page: query?.page,
        size: query?.size
      }
    })
  }

  const getDataPuchaseClientAdventure = async (cliendId?: any): Promise<AxiosResponse<any>> => {
    return await api.get(`/WS/Cliente/${cliendId}/DadosCompra`)
  }

  const deleteDataAventure = async (adventureId?: any): Promise<AxiosResponse<any>> => {
    return await api.delete(`/WS/Aventura/${adventureId}`)
  }

  const getDataRating = async (adventureId?: any): Promise<AxiosResponse<any>> => {
    return await api.get(`/WS/Aventura/${adventureId}/Avaliacoes`)
  }

  return {
    favoriteAdventure,
    desfavoriteAdventure,
    getSchedulesAdventures,
    getListClasses,
    getListSubscribed,
    createAdventure,
    getCommunityAdventures,
    getAdventuresTime,
    getDataPuchaseClientAdventure,
    deleteDataAventure,
    getDataRating
  };
}
