import { useRouter } from "next/router";
import { parseCookies, setCookie } from "nookies";
import React, { createContext, Dispatch, SetStateAction, useCallback, useContext, useEffect, useState } from "react";
import useUser from "../hooks/useUser";
import { User } from "../models/interfaces/User/User";
import { languages, usePreferencesContext } from "./PreferencesContext";

interface UserContext {
  user: User;
  setUser: Dispatch<SetStateAction<User>>;
  isAuthenticated: boolean;
  updateUser: () => void;
}

export const UserContext = createContext<UserContext>({} as UserContext);

var savedUser = parseCookies(undefined, { path: "/" }).user;

export const UserProvider = ({ children }: any) => {
  const [isAuthenticated, setIsAutheticated] = useState<boolean>(false);
  const [user, setUser] = useState<User>(savedUser ? JSON.parse(savedUser) : {});
  const { getUpdatedProfile } = useUser();
  const { changeLanguage, preferences, setPreferences } = usePreferencesContext();
  const router = useRouter();

  const updateUser = useCallback(async () => {
    let savedUser = parseCookies(undefined, { path: "/" }).user;
    let token = parseCookies(undefined, { path: "/" }).access_token;
    setIsAutheticated(true);
    if (savedUser && token) {
      getUpdatedProfile(JSON.parse(savedUser).id).then((result) => {
        setUser(result.data);
        setCookie(undefined, "user", JSON.stringify(result.data), { path: "/", maxAge: 30 * 24 * 60 * 60 * 2 });

        if (result.data.linguagemAtual != router.locale) {
          changeLanguage(result.data.linguagemAtual as languages);
          setPreferences({ ...preferences, language: result.data.linguagemAtual as languages });
        }
      });
    }
  }, []);

  useEffect(() => {
    updateUser();
  }, [updateUser]);

  useEffect(() => {
    let savedUser = parseCookies(undefined, { path: "/" }).user;
    let token = parseCookies(undefined, { path: "/" }).access_token;
    if (savedUser && token) {
      setIsAutheticated(true);
    } else {
      setIsAutheticated(false);
    }
  }, [user]);

  return <UserContext.Provider value={{ user, setUser, isAuthenticated, updateUser }}>{children}</UserContext.Provider>;
};

export const useUserContext = () => useContext(UserContext);
