import i18next from "i18next";
import { parseCookies, setCookie } from "nookies";
import React, { createContext, Dispatch, SetStateAction, useContext, useEffect, useState } from "react";
import { useTranslation } from "next-i18next";
import useUser from "../hooks/useUser";
import router from "next/router";

interface PreferencesContext {
  preferences: Preferences;
  setPreferences: Dispatch<SetStateAction<Preferences>>;
  changeLanguage: (language: languages) => void;
}

export type languages = "pt" | "en" | "es";
export interface Preferences {
  language: languages;
}

export const PreferencesContext = createContext<PreferencesContext>({} as PreferencesContext);

export const PreferencesProvider = ({ children }: any) => {
  const [preferences, setPreferences] = useState<Preferences>({
    language: "pt",
  });
  const { updateUserLanguage } = useUser();

  const changeLanguage = (language: languages) => {
    if (language != preferences.language) {
      //**Garantindo que o cookie não será setado como pt-BR */
      if (language && language.toLowerCase().includes("br")) {
        language = "pt";
      }
      setCookie(undefined, "language", language, { path: "/", maxAge: 30 * 24 * 60 * 60 * 2 });
      updateUserLanguage(language);
      router.reload();
    }
  };

  useEffect(() => {
    setPreferences({ language: (parseCookies(undefined, { path: "/" }).language || "pt") as languages });
  }, []);

  return (
    <PreferencesContext.Provider value={{ preferences, changeLanguage, setPreferences }}>
      {children}
    </PreferencesContext.Provider>
  );
};

export const usePreferencesContext = () => useContext(PreferencesContext);
