import { parseCookies, setCookie } from "nookies";
import React, { createContext, Dispatch, SetStateAction, useContext, useEffect, useState } from "react";

interface GeolocationContext {
  lastLocation: LatLong;
  setLastLocation: Dispatch<SetStateAction<LatLong>>;
  localizationMaps: any;
  setLocalizationMaps: any
}

export interface LatLong {
  lat: number;
  lng: number;
}

export const GeolocationContext = createContext<GeolocationContext>({} as GeolocationContext);

var savedLocation = parseCookies(undefined, { path: "/" }).last_location;

export const GeolocationProvider = ({ children }: any) => {
  const [lastLocation, setLastLocation] = useState<LatLong>(
    savedLocation ? JSON.parse(savedLocation) : { lat: -14.5512, lng: -52.5795 }
  );

  const [localizationMaps, setLocalizationMaps] = useState(null)

  useEffect(() => {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(
        (position: GeolocationPosition) => {
          const userPosition = {
            lat: position.coords.latitude,
            lng: position.coords.longitude,
          };

          setCookie(undefined, "last_location", JSON.stringify(userPosition), {
            path: "/",
            maxAge: 30 * 24 * 60 * 60 * 2,
          });
          setLastLocation(userPosition);
        },
        (error) => {
          ///VERIFICAR COMO SE COMPORTA EM OUTRAS APLICAÇÕES,
          // MAC PRECISA DAR PERMISSÃO DE LOCALIZAÇÃO NAS PREFERENCAS
          console.log(error);
        }
      );
    } else {
      //NAVEGADOR SEM ACESSO A GEOLOCALIZAÇÃO
    }
  }, []);

  return (
    <GeolocationContext.Provider value={{ lastLocation, setLastLocation, localizationMaps, setLocalizationMaps }}>{children}</GeolocationContext.Provider>
  );
};

export const useGeolocationContext = () => useContext(GeolocationContext);
