import { useRouter } from "next/dist/client/router";
import { parseCookies } from "nookies";
import { ElementType, useEffect } from "react";

export default function WithAuth(Component: ElementType) {
  const Wrapper = (props: any) => {
    const router = useRouter();

    useEffect(() => {
      const token = parseCookies(undefined, { path: "/" }).access_token;
      if (!token) {
        router.replace("/home");
      }
    }, [router]);
{/* @ts-ignore */}
    return <Component {...props} />;
  };
  return Wrapper;
}
