import { Form, Formik } from "formik";
import { useTranslation } from "next-i18next";
import { Dialog } from "primereact/dialog";
import { Toast } from "primereact/toast";
import { useEffect, useRef, useState } from "react";
import * as Yup from "yup";
import YupPassword from "yup-password";
import useUser from "../../../../core/hooks/useUser";
import { Util } from "../../../../core/utils/util";
import Button from "../../Button";
import Input from "../../CustomInput";
import Password from "../../SvgIcons/password";
import { InputGroup } from './styles';

YupPassword(Yup);

export default function ChangeUserPasswordModal(props: any){
    const toast = useRef(null);
    const [visible, setVisible] = useState(false)
    const { changeUserPassword } = useUser();
    const { t } = useTranslation("common");

    useEffect(() => {
        setVisible(props.visible)
    }, [props.visible])

    const onSubmit = async (password: string) => {
        const response = await changeUserPassword(props.data.id, password);
        if(response.status === 200){
            Util.showSucessToast(toast, `A senha do usuário '${props.data.nome}' foi alterada com sucesso!`);
            props.onHide()
        }else{
            Util.showErrorToast(toast, `Erro ao alterar senha do usuário '${props.data.nome}'!`);        
        }
    } 

    const initialValues = {
        password: "",
    };

    const validationSchema = Yup.object({
        password: Yup.string()
            .password()
            .required(t("requiredField"))
            .minUppercase(0)
            .minLowercase(0)
            .minSymbols(0)
            .minNumbers(0)
            .min(6, t("passwordLength"))
            .max(16, t("passwordLength"))
    });

    return (
        <>
        {/* @ts-ignore */}
            <Toast ref={toast} position="top-center" />
{/* @ts-ignore */}
            <Dialog header="Alteração de senha" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
                <div>
                    Você está alterando a senha de '{props.data.nome}', digite a nova senha abaixo:
                </div>
                <br/>
                <Formik
                    initialValues={initialValues}
                    validationSchema={validationSchema}
                    onSubmit={(values) => { onSubmit(values.password) }}
                    validateOnChange
                    >
                    {(formik) => {
                        return (
                            <Form>
                                <InputGroup inputs={1}>
                                    <Input
                                        id="password"
                                        name="password"
                                        label="Senha:"
                                        placeholder="******"
                                        type="password"
                                        error={formik.errors.password && formik.touched.password}
                                        icon={<Password width={20} height={20}/>}
                                        />
                                </InputGroup>
                                <InputGroup inputs={2}>
                                    <Button type="button" color="#495057a3" onClick={() => props.onHide()} text="Cancelar"/>
                                    <Button type="submit" text="Enviar nova senha" disabled={!formik.isValid}/>
                                </InputGroup>
                            </Form>
                        )
                    }}
                </Formik>
            </Dialog>
        </>
    )
}