import { ReactNode, useEffect, useRef } from "react";
import styled from "styled-components";

interface TooltipProps {
  children: ReactNode;
  text: string;
  active: boolean;
  timeActive?: number;
}

export default function Tooltip({ children, text, active = false, timeActive = 1000 }: TooltipProps) {
  const tooltipRef = useRef<any>();

  useEffect(() => {
    if (active) {
      tooltipRef.current.style.animationFillMode = "forwards";
      tooltipRef.current.style.visibility = "visible";
      setTimeout(() => {
        if (tooltipRef?.current && tooltipRef.current.style) {
          tooltipRef.current.style.visibility = "hidden";
        }
      }, timeActive);
    }
  }, [active, timeActive]);

  return (
    <Wrapper>
      <TooltipContainer ref={tooltipRef}>{text}</TooltipContainer>
      {children}
    </Wrapper>
  );
}

const Wrapper = styled.div`
  position: relative;
  display: flex;
  justify-content: center;
  align-items: center;
  cursor: pointer;
  padding: 2px;

  :active {
    opacity: 0.5;
  }
`;

const TooltipContainer = styled.span`
  visibility: hidden;
  min-width: 80px;
  background-color: ${(p) => p.theme.primaryBackground};
  color: ${(p) => p.theme.primaryForeground};
  text-align: center;
  font-size: 12px;
  border-radius: ${(p) => p.theme.borderRadius};
  padding: 5px;
  top: 22px;
  margin-left: 5px;
  position: absolute;
  z-index: 1;
`;
