import React from "react";
import { useTheme } from "styled-components";

interface CustomProps extends React.SVGProps<SVGSVGElement> {
  active?: boolean;
}

function Water(props: CustomProps) {
  const theme = useTheme();

  return (
    <svg xmlns="http://www.w3.org/2000/svg" width="55pt" height="55pt" viewBox="0 0 55 55" {...props}>
      <g fill={!props.active ? theme.inactiveElementBackground : theme.waterColor}>
        <path d="M27.5 0C12.312 0 0 12.313 0 27.5 0 42.688 12.313 55 27.5 55 42.688 55 55 42.687 55 27.5 55 12.312 42.687 0 27.5 0zm0 50.012c-12.434 0-22.512-10.078-22.512-22.512 0-12.434 10.078-22.512 22.512-22.512 12.434 0 22.512 10.078 22.512 22.512-.016 12.426-10.086 22.496-22.512 22.512zm0 0" />
        <path d="M47.328 24.785a19.43 19.43 0 00-.39-2.055v-.02a20.065 20.065 0 00-.477-1.655c-2.305 1.11-5.598.89-7.547-.723a2.223 2.223 0 00-2.777.117 6.7 6.7 0 01-3.403 1.32.913.913 0 00-.101.016l-.117-.023a6.86 6.86 0 01-3.418-1.348 2.29 2.29 0 00-2.844 0 7.387 7.387 0 01-8.59-.09 2.188 2.188 0 00-2.75.106 7.437 7.437 0 01-6.488.984 19.668 19.668 0 00-.793 3.703 20.145 20.145 0 00-.031 4.473 19.863 19.863 0 001.93 6.71 20.103 20.103 0 004.284 5.782 19.979 19.979 0 006.957 4.246l.008.004h.008a19.913 19.913 0 005.602 1.125h.027a20.175 20.175 0 005.016-.36h.02l.034-.011a19.688 19.688 0 002.86-.809l.062-.015.05-.024a20.128 20.128 0 003.247-1.554l.04-.02.03-.023a19.89 19.89 0 003.188-2.368 20.17 20.17 0 003.117-3.601c.211-.313.41-.633.602-.957l.007-.008.004-.012a19.765 19.765 0 002.75-8.773 20.06 20.06 0 00-.117-4.137zm-14.613 9.426a2.846 2.846 0 01-2.848-2.848 2.846 2.846 0 012.848-2.847 2.846 2.846 0 012.847 2.847 2.846 2.846 0 01-2.847 2.848zM35.562 27a1.509 1.509 0 013.016 0c0 .832-.676 1.508-1.508 1.508A1.508 1.508 0 0135.566 27zm3.657 9.336a2.124 2.124 0 11.004 0zm0 0" />
      </g>
    </svg>
  );
}

export default React.memo(Water);
