import React from "react";
import { useTheme } from "styled-components";

interface CustomProps extends React.SVGProps<SVGSVGElement> {
  active?: boolean;
}

function Share(props: CustomProps) {
  const theme = useTheme();
  return (
    <svg xmlns="http://www.w3.org/2000/svg" width={18} height={20.571} {...props}>
      <path
        d="M14.143 12.857a3.84 3.84 0 00-2.4.84l-4.12-2.574a3.879 3.879 0 000-1.675l4.118-2.574a3.85 3.85 0 10-1.363-2.18L6.259 7.268a3.857 3.857 0 100 6.035l4.118 2.574a3.857 3.857 0 103.766-3.02z"
        fill={theme.pageForeground}
      />
    </svg>
  );
}

export default React.memo(Share);
