import React from "react";
import { useTheme } from "styled-components";

function Marker(props: React.SVGProps<SVGSVGElement>) {
  const theme = useTheme();
  return (
    <svg xmlns="http://www.w3.org/2000/svg" width="50pt" height="89pt" viewBox="0 0 50 89" {...props}>
      <path
        d="M23.914.016a25.164 25.164 0 00-8.328 1.804A25.08 25.08 0 003.46 12.262 24.745 24.745 0 00.098 22.66c-.082.895-.125 2.32-.086 3 .218 3.738 1.883 9.793 5.027 18.258 3.723 10.023 9.738 23.84 16.848 38.687 1.441 3.012 3.086 6.391 3.113 6.391.027 0 1.676-3.379 3.117-6.39 7.727-16.141 14.09-30.895 17.742-41.137 2.57-7.207 3.926-12.39 4.13-15.778.03-.543.015-1.671-.04-2.46a24.817 24.817 0 00-5.402-13.856 25.066 25.066 0 00-11.25-7.977A25.024 25.024 0 0026.043.016a48.35 48.35 0 00-2.129 0zm1.95 13.906c.429.039.738.074 1.105.14a11.087 11.087 0 015.3 2.54c.266.23.852.808 1.075 1.062a11.061 11.061 0 012.566 5.3c.121.665.172 1.278.172 2 0 .532-.02.884-.086 1.391-.379 3.043-2.043 5.81-4.566 7.606a11.032 11.032 0 01-4.996 1.96c-.536.071-.836.087-1.434.087-.594 0-.895-.016-1.43-.086a11.06 11.06 0 01-4.996-1.961 11.071 11.071 0 01-4.488-7.063 11.433 11.433 0 01-.082-3.347 11.032 11.032 0 012.633-5.856c.238-.277.816-.851 1.097-1.093 1.817-1.567 3.98-2.473 6.383-2.68.461-.04 1.278-.04 1.746 0zm0 0"
        fill={theme.primaryBackground}
      />
    </svg>
  );
}

export default React.memo(Marker);
