import React from "react";
import { useTheme } from "styled-components";

function Mail(props: React.SVGProps<SVGSVGElement>) {
  const theme = useTheme();
  return (
    <svg xmlns="http://www.w3.org/2000/svg" width="20pt" height={20} viewBox="0 0 20 15" {...props}>
      <path
        d="M19.621 4.809a.243.243 0 01.246-.028c.078.04.133.117.133.203v7.754c0 1.004-.84 1.82-1.875 1.82H1.875C.84 14.559 0 13.747 0 12.739v-7.75c0-.086.05-.164.133-.203a.243.243 0 01.246.027c.875.66 2.035 1.5 6.02 4.31.824.585 2.214 1.808 3.601 1.8 1.395.012 2.813-1.242 3.605-1.805C17.59 6.31 18.746 5.47 19.621 4.81zM10 9.707c.91.016 2.21-1.11 2.867-1.57 5.184-3.653 5.578-3.973 6.774-4.88a.896.896 0 00.363-.718V1.82c0-.484-.2-.945-.55-1.289A1.91 1.91 0 0018.124 0H1.875C.84 0 0 .816 0 1.82v.72c0 .28.137.546.363.718 1.196.906 1.59 1.226 6.774 4.879.652.46 1.953 1.586 2.863 1.57zm0 0"
        fill={theme.primaryBackground}
      />
    </svg>
  );
}

export default React.memo(Mail);
