import * as React from "react";
import { useTheme } from "styled-components";

function Heart(props: React.SVGProps<SVGSVGElement>) {
  const theme = useTheme();
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width={24}
      height={21.006}
      viewBox="0 0 24 21.006"
      fill={theme.pageForeground}
      {...props}
    >
      <path d="M21.487 1.515A7.061 7.061 0 0012 2.222a7.056 7.056 0 00-9.487-.7 7.092 7.092 0 00-.5 10.369l8.222 8.377a2.462 2.462 0 003.525 0l8.222-8.377a7.1 7.1 0 00-.495-10.376zm-1.106 8.789l-8.222 8.377a.193.193 0 01-.319 0l-8.221-8.377a4.834 4.834 0 01.342-7.064 4.753 4.753 0 016.4.492L12 5.406l1.641-1.673a4.749 4.749 0 016.4-.5 4.855 4.855 0 01.342 7.069z" />
    </svg>
  );
}

export default Heart;
