import * as React from "react";
import { useTheme } from "styled-components";

interface CustomProps extends React.SVGProps<SVGSVGElement> {
  active?: boolean;
}

function Earth(props: CustomProps) {
  const theme = useTheme();

  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width={101.333}
      height={101.333}
      viewBox="0 0 76 76"
      fill={!props.active ? theme.inactiveElementBackground : theme.earthColor}
      {...props}
    >
      <path d="M31.8 1C20.1 3 9.1 11.3 4.4 21.5c-15 32.7 17.4 65.1 50.1 50.1C75.7 61.9 82 33 67.1 14.1 59.4 4.4 44.6-1.1 31.8 1zm18.8 8.4c7.2 3.4 11.9 7.8 15.4 14.8 2.6 5.2 3 7.2 3 13.7 0 12.8-5.9 22.4-17.2 28.1-5.2 2.6-7.2 3-13.8 3-6.6 0-8.6-.4-13.8-3C13 60.3 7 50.7 7 38s6-22.3 17.2-28c8.1-4 18.6-4.3 26.4-.6z" />
      <path d="M27.7 17.2c-1.4 1.8-5.7 8.3-9.6 14.4L11 42.7l1.5 4.2c2 5.7 5 9.7 9.8 13.2 4 2.9 4.1 2.9 4.9 1 1.1-3 6-5.7 13.7-7.5 10.2-2.5 12.3-3.6 11.8-5.8-.6-2.3 1.2-1.9 2.7.5 1.7 2.7-.3 4.8-9 9.4-4.3 2.3-8 4.7-8.2 5.2-.7 2.1 3.1 2.4 8.6.7 7-2.3 14.2-9.2 16.5-15.8l1.5-4.7-6.2-9.7c-3.5-5.4-6.7-9.9-7.2-10.1-.5-.1-2.2 2-3.9 4.7-1.6 2.8-3.2 5-3.7 5-.4 0-3.5-4.3-6.9-9.5-3.3-5.2-6.3-9.5-6.5-9.5-.1 0-1.4 1.5-2.7 3.2zm5.4 10.6c-1.4.2-3.5 1.2-4.7 2.3-1.8 1.7-2.3 1.8-3.3.5-.7-.8-.9-2.1-.5-2.8.4-.7 1.9-3.1 3.2-5.2l2.4-3.9 2.8 4.4 2.7 4.4-2.6.3zm20.3 1.4c2 2.9 2 3.8-.1 3.8-.9 0-2.5.7-3.5 1.6-1.6 1.5-1.8 1.5-2.4.1-.6-1.6 2.4-7.7 3.8-7.7.4 0 1.4 1 2.2 2.2z" />
    </svg>
  );
}

export default React.memo(Earth);
