import * as React from "react";
import { useTheme } from "styled-components";

interface CustomProps extends React.SVGProps<SVGSVGElement> {
  active?: boolean;
}

function All(props: CustomProps) {
  const theme = useTheme();
  return (
    <svg xmlns="http://www.w3.org/2000/svg" width="55pt" height="55pt" viewBox="0 0 55 55" {...props}>
      <g fill={!props.active ? theme.inactiveElementBackground : theme.primaryBackground}>
        <path d="M27.5 0C12.312 0 0 12.313 0 27.5 0 42.688 12.313 55 27.5 55 42.688 55 55 42.687 55 27.5 55 12.312 42.687 0 27.5 0zm0 50.012c-12.434 0-22.512-10.078-22.512-22.512 0-12.434 10.078-22.512 22.512-22.512 12.434 0 22.512 10.078 22.512 22.512-.016 12.426-10.086 22.496-22.512 22.512zm0 0" />
        <path d="M38.16 36.64a1.47 1.47 0 00-1.805.122 6.866 6.866 0 01-3.496 1.36l-.144.034-.172-.035c-.008 0-.016-.004-.023-.004a7.043 7.043 0 01-3.497-1.387 1.514 1.514 0 00-1.875-.007 7.469 7.469 0 01-8.8-.086 1.424 1.424 0 00-1.782.105 7.45 7.45 0 01-6.007 1.184c-.008.027-.012.05-.02.078a19.92 19.92 0 0017.043 9.476 19.917 19.917 0 0016.969-9.613 7.496 7.496 0 01-6.39-1.226zm0 0" />
        <path d="M38.027 23a1.034 1.034 0 00-1.738 0l-4.66 7.25-8.59-13.36a1.428 1.428 0 00-2.398 0L9.008 34.989c.207.516.433 1.016.68 1.508l.035-.101.59.18a6.336 6.336 0 005.476-.81 2.644 2.644 0 013.352-.09 6.312 6.312 0 007.222.075 2.775 2.775 0 013.426-.004 5.747 5.747 0 002.871 1.133l.05.004h.02a5.583 5.583 0 002.852-1.102 2.697 2.697 0 013.371-.097 6.386 6.386 0 006.371.593l.125-.062c.156-.32.305-.649.442-.98zM21.84 26.219l-2.852 2.855-1.695-1.699 4.547-7.074 3.805 5.918zm15.32 3.535l-2.066 2.066-1.23-1.23 3.292-5.125 2.758 4.289zm0 0" />
        <path d="M28.809 21.41a3.128 3.128 0 003.625-2.027.445.445 0 00-.063-.406.438.438 0 00-.367-.184h-.945a.46.46 0 00-.407.21c-.32.567-1.007.821-1.62.602a1.345 1.345 0 01.457-2.61l3.261.001c.184-.695.57-1.32 1.117-1.793h-4.383A3.143 3.143 0 0026.36 18a3.142 3.142 0 002.446 3.406zm0 0M33.547 17.547a2.69 2.69 0 005.305.867.456.456 0 00-.102-.363.456.456 0 00-.344-.153h-.918a.441.441 0 00-.425.282.901.901 0 01-1.07.586.902.902 0 01-.669-1.02.94.94 0 01.938-.746h8.164a21.053 21.053 0 00-1.254-1.793h-6.867a2.752 2.752 0 00-2.758 2.34zm0 0M30.832 14.313h11.59a20.528 20.528 0 00-1.8-1.793h-9.74a.936.936 0 01-.937-.747.898.898 0 011.739-.433c.066.176.238.289.425.285h.918a.446.446 0 00.446-.516 2.69 2.69 0 00-5.325.688 2.689 2.689 0 002.684 2.515zm0 0" />
      </g>
    </svg>
  );
}

export default All;
