import React from "react";
import { useTheme } from "styled-components";

interface CustomProps extends React.SVGProps<SVGSVGElement> {
  active?: boolean;
}

function Air(props: CustomProps) {
  const theme = useTheme();

  return (
    <svg xmlns="http://www.w3.org/2000/svg" width="55pt" height="55pt" viewBox="0 0 55 55" {...props}>
      <g fill={!props.active ? theme.inactiveElementBackground : theme.airColor}>
        <path d="M27.5 0C12.312 0 0 12.313 0 27.5 0 42.688 12.313 55 27.5 55 42.688 55 55 42.687 55 27.5 55 12.312 42.687 0 27.5 0zm0 50.012c-12.434 0-22.512-10.078-22.512-22.512 0-12.434 10.078-22.512 22.512-22.512 12.434 0 22.512 10.078 22.512 22.512-.016 12.426-10.086 22.496-22.512 22.512zm0 0" />
        <path d="M27.5 7.54c-9.867.015-18.25 7.226-19.738 16.98.093-.028.187-.043.281-.043h11.508a2.11 2.11 0 002.105-1.676 2.021 2.021 0 00-3.91-.977.995.995 0 01-.957.637h-2.062a1.009 1.009 0 01-1-1.16 6.048 6.048 0 016.914-4.813 6.05 6.05 0 015.02 6.766 6.182 6.182 0 01-6.2 5.254H8.043a.943.943 0 01-.48-.13c.03.735.101 1.466.214 2.188.09-.027.18-.039.27-.039h23.715a6.05 6.05 0 11-5.934 7.2.992.992 0 01.996-1.152h2.067a.99.99 0 01.957.636 2.019 2.019 0 003.906-.977 2.097 2.097 0 00-2.106-1.683H8.828c3.57 9.445 13.629 14.738 23.434 12.328 9.804-2.406 16.265-11.758 15.054-21.781C46.102 15.078 37.598 7.539 27.5 7.539zm7.285 20.968h-9.844a7.969 7.969 0 002.508-4.031h7.336a3.025 3.025 0 001.035-5.872 3.024 3.024 0 00-3.652 1.36 1.05 1.05 0 01-.918.476h-2.125a1.02 1.02 0 01-.824-.418 1.017 1.017 0 01-.14-.914 7.047 7.047 0 116.624 9.395zm0 0" />
      </g>
    </svg>
  );
}

export default React.memo(Air);
