import { Dialog } from "primereact/dialog"
import { Formik, Form } from "formik";
import Button from "../Button";
import { useEffect, useRef, useState } from "react";
import Input  from "../CustomInput";
import { InputGroup, InputContainer } from "./styles";
import { Toast } from "primereact/toast";
import useEstablishment from "../../../core/hooks/useEstablishment";
import { Util } from "../../../core/utils/util";


export default function SupplierModalComission(props: any) {
    
    const toast = useRef(null);
    const [visible, setVisible] = useState(false)
    const [comission, setComission] = useState<any>({})
    const { saveSupplierComission } = useEstablishment()

    const saveComissionSupplier = async () => {
        {/* @ts-ignore */}
        if(comission.porcentagemCobrada == null || comission.porcentagemCobrada == undefined){
            {/* @ts-ignore */}
            comission.porcentagemCobrada = 20
        }

        try{
            const response = await saveSupplierComission(comission)
            console.log(response)
            if(response.status === 200){
                setVisible(!visible)
                Util.showSucessToast(toast, "Comissão alterada com sucesso");
            }
        } catch(e) {
            Util.showErrorToast(toast, "Erro ao alterar comissão");
        }
    }

    useEffect(() => {
        setVisible(props.visible)
        setComission({
            id: props.data.id,
            porcentagemCobrada: null
        })
    }, [props.visible])

    return(
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />
{/* @ts-ignore */}
        <Dialog header="Porcentagem de cobrança" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
            {/* @ts-ignore */}
            <Formik>
            <Form>
            <div>
                Você está alterando a porcentagem de cobrança <b> {props.data.nome} </b> (valor em branco significa 20%)
            </div>
            <InputGroup inputs={1}>
                <InputContainer>
                    {/* @ts-ignore */}
                    <Input
                        name="comission"
                        placeholder="Comissão"
                        type="number"
                        min="1"
                        max="100"
                        value={comission?.porcentagemCobrada}
                        onChange={(e: any) => {
                                const value = e.target.value
                                if(value.length >= 3){
                                    {/* @ts-ignore */}
                                    setComission(prevState => {
                                        return { ...prevState, porcentagemCobrada: 100 }
                                    })
                                } else {
                                    {/* @ts-ignore */}
                                    setComission(prevState => {
                                        return { ...prevState, porcentagemCobrada: parseInt(value) }
                                    })
                                }
                            }
                        }
                    />
                </InputContainer>
            </InputGroup>
                <Button type="button" onClick={() => saveComissionSupplier()} text="Salvar alterações"></Button>
            </Form>
            </Formik>
        </Dialog>
        </>
    )
}