import { Dialog } from "primereact/dialog"
import { useEffect, useReducer, useRef, useState } from "react"
import Button from "../Button"
import { InputGroup } from './styles'
import { Util } from "../../../core/utils/util"
import { Toast } from "primereact/toast"
import useClient from "../../../core/hooks/useClient"

export default function DeleteModalCategory(props: any){
    const toast = useRef(null);
    const [visible, setVisible] = useState(false)
    const [subscribed, setSubscribed] = useState({})
    const [_, forceUpdate] = useReducer((x) => x + 1, 0);
    const { saveDataSubscribed } = useClient();

    useEffect(() => {
        setVisible(props.visible)
        setSubscribed(props.data)
    }, [props.visible])

    const saveNewStatus = async (subscribed: object, newStatus: string) => {
        const response = await saveDataSubscribed(subscribed, newStatus)
        if(response.status === 200){
            props.data.statusPresenca = newStatus
            forceUpdate()
            props.onHide()
        }
    }

    return (
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />

        {/* @ts-ignore */}
        <Dialog header="Atenção" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
            <div>
                Você deve informar se o cliente esteve presente durante a aventura. o Cliente:
            </div>
            <br/>
            <InputGroup inputs={2}>
                <Button type="button" color="#495057a3" onClick={() => saveNewStatus(subscribed, "AUSENTE") } text="Não comparaceu"></Button>
                <Button type="button" text="Compareceu" onClick={() => saveNewStatus(subscribed, "PRESENTE") }></Button>
            </InputGroup>
        </Dialog>
        </>
    )
}