import { Dialog } from "primereact/dialog"
import Button from "../Button";
import { useEffect, useReducer, useRef, useState } from "react";
import { InputGroup,} from "./styles";
import { Toast } from "primereact/toast";
import useUser from "../../../core/hooks/useUser";
import { Util } from "../../../core/utils/util"

export default function ModalMakeAdmin(props: any){
    const toast = useRef(null);
    const [visible, setVisible] = useState(false)
    const { makeUserAdm } = useUser()
    const [_, forceUpdate] = useReducer((x) => x + 1, 0);

    const makeAdm = async (usuario: { id: number; profiles: any; }) => {
        const response = await makeUserAdm(usuario.id);
        if(response.status === 200){
            if(!usuario.profiles.includes('adm')){
                props.data.perfis += "adm";
                Util.showSucessToast(toast, "Usuario tornou Admin");
            } else {
                props.data.perfis = usuario.profiles.replace("adm", "");
                Util.showSucessToast(toast, "Permissão Admin removido");
            }
            forceUpdate()
        }
        props.onHide()
    };

    useEffect(() => {
        setVisible(props.visible)
    }, [props.visible])

    return(
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />
{/* @ts-ignore */}
        <Dialog header="Atenção" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
            {props.data.perfis?.indexOf('adm') != -1 ? (
            <div>
                Você tem certeza que deseja remover esta permissão de administrador para este usuário ?
            </div>
            ) : (
                <div>
                    Você tem certeza que deseja tornar este usuário um administrador?
                </div>
            )}
            <br/>
            <InputGroup inputs={2}>
                <Button type="button" color="#495057a3" onClick={() => props.onHide()} text="Não"></Button>
                <Button type="button" text="Sim" onClick={() => makeAdm({ id: props.data.id, profiles: props.data.perfis })} />
            </InputGroup>
        </Dialog>
        </>
    )
}