import { Dialog } from "primereact/dialog"
import { useEffect, useState } from "react"
import ModalDefineTimeSaveNewHours from '../../ModalDefineTimeSave/ModalDefineTimeSaveNewHours'
import Button from "../../Button"
import { DataView } from 'primereact/dataview';
import useEstablishment from "../../../../core/hooks/useEstablishment";

export default function ModalDefineTimeNewHours(props: any){

    const [visible, setVisible] = useState(false)
    const [visibleModalDefineTimeSaveNewHours, setVisibleModalDefineTimeSaveNewHours] = useState(false)
    const [times, setTimes] = useState([])
    const { getListTimeLocalStorage, saveListTimeLocalStorage } = useEstablishment();
    const [dataListTimes] = useState({})

    const updateTimesList = (event: any) => {
        let listDateTimeLocalStorage = getListTimeLocalStorage()

        listDateTimeLocalStorage.push(event)
        saveListTimeLocalStorage(listDateTimeLocalStorage)

        if(listDateTimeLocalStorage){
            setTimes(listDateTimeLocalStorage)
        } else {
            setTimes([])
        }
    }

    useEffect(() => {
        setVisible(props.visible)
        let listDateTimeLocalStorage = getListTimeLocalStorage()
        saveListTimeLocalStorage(listDateTimeLocalStorage)

        if(listDateTimeLocalStorage == null){
            setTimes([])
        } else {
            setTimes(listDateTimeLocalStorage)
        }
        
    }, [props.visible])

    const deleteTime = (item: object) => {
        let listDateTimeLocalStorage = getListTimeLocalStorage()
        {/* @ts-ignore */}
        listDateTimeLocalStorage = listDateTimeLocalStorage.filter(i => i.id != item.id)
        saveListTimeLocalStorage(listDateTimeLocalStorage)
        setTimes(listDateTimeLocalStorage)
    }

    const itemTemplate = (item: any) => {

        const renderDayName = (dayWeek: any) => {
            if (dayWeek === 'MONDAY'){
                return 'Segunda-feira'
            } else if(dayWeek === 'TUESDAY'){
                return 'Terça-feira'
            } else if(dayWeek === 'WEDNESDAY'){
                return 'Quarta-feira'
            } else if(dayWeek === 'THURSDAY'){
                return 'Quinta-feira'
            } else if(dayWeek === 'FRIDAY'){
                return 'Sexta-feira'
            } else if(dayWeek === 'SATURDAY'){
                return 'Sabado'
            } else if(dayWeek === 'SUNDAY'){
                return 'Domingo'
            } else {
                return '-'
            }
        }

        return <>
            <div className="p-col-6" style={{ marginTop: '10px' }}>
                {item.tipoHorario == "SEMANAL" ? (
                <div>
                    <b> { item.diaSemana == 'T' ? 'Todos os dias' : renderDayName(item.diaSemana) || 'Todos os dias' } </b>
                </div>
                ) : (
                <div>
                    <b> { item.dataInicial?.split('-').reverse().join('/') } à { item.dataFinal.split('-').reverse().join('/') } </b>
                </div>
                ) }
                <div>
                    <small> Horário inicial: { item.dataInicial?.split('-').reverse().join('/') } às { item.horarioInicial } </small>
                </div>
                <div>
                    <small> Horário inicial: { item.dataFinal?.split('-').reverse().join('/') } às { item.horarioFinal } </small>
                </div>
                <div>
                    <small> Pessoas: { item.quantidadePessoas || 'Aberto' } </small>
                </div>
                
            </div>
            <div className="p-col-6" style={{ marginTop: '18px' }}>
                <Button text="Excluir" onClick={() => deleteTime(item) }/>
            </div>
        </>
    }

    return (
        <>
        {/* @ts-ignore */}
            <Dialog header="Horários da aventura" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
                <ModalDefineTimeSaveNewHours visible={visibleModalDefineTimeSaveNewHours} data={dataListTimes} update={(event: object) => updateTimesList(event) } style={{ width: '50vw' }} onHide={() => { setVisibleModalDefineTimeSaveNewHours(!visibleModalDefineTimeSaveNewHours) } } />
                <Button text="Novo horário" onClick={() => { setVisibleModalDefineTimeSaveNewHours(!visibleModalDefineTimeSaveNewHours); }}/>
                {times.length ? (
                    <DataView 
                        value={times}
                        itemTemplate={itemTemplate}
                        header={<div> Lista de horários </div>} 
                />) : (<></>)}
            </Dialog>
        </>
    )
}