import { Dialog } from "primereact/dialog"
import { Calendar } from "primereact/calendar"
import { useEffect, useState } from "react"
import { InputGroup, InputContainer } from "./styles"
import Input from "../../CustomInput"
import { Formik, Form } from "formik";
import Button from "../../Button"
import { concat, isNull } from "lodash"
import useEstablishment from "../../../../core/hooks/useEstablishment"

export default function ModalDefineTimeSaveNewHours(props: any){

    const [visible, setVisible] = useState(false)
    const listOption = [{ key: "Tipo de horário", value: 'Typetime' },
                        { key: "Por data", value: 'DATA' },
                        { key: "Semanal", value: 'SEMANAL' }
    ]
    const { getListTimeLocalStorage, saveListTimeLocalStorage } = useEstablishment();
    const listOptionDaysWeek = [
        { key: "Todos os dias", value: 'T' },
        { key: "Segunda-feira", value: 'MONDAY' },
        { key: "Terça-feira", value: 'TUESDAY' },
        { key: "Quarta-feira", value: 'WEDNESDAY' },
        { key: "Quinta-feira", value: 'THURSDAY' },
        { key: "Sexta-feira", value: 'FRIDAY' },
        { key: "Sabado", value: 'SATURDAY' },
        { key: "Domingo", value: 'SUNDAY' },
    ]
    const [times, setTimes] = useState<any>({})
    const [visibleTypeDataTime, setVisibleDataTime] = useState("Typetime")
    const [dates, setDates] = useState<Date[] | any>()

    const formatStringData = (event: any) => {
        if(event != undefined){
            const dateTime = event.toLocaleString('pt-br')?.split(',')
            if(dateTime){
                return(
                    <b style={{ fontSize: '12px', textAlign: 'center' }}>
                        { dateTime[1] ? `A aventura começa dia ${dateTime[0].replace('00:00:00', '')} e termina dia ${dateTime[1].replace('00:00:00', '')}` : `A aventura começa dia ${dateTime[0].replace('00:00:00', '')}` }
                    </b>
                )
            }
        }
    }

    const onSubmit = () => {
        const isValid = () => {
            if(times.tipoHorario.includes('DATA')){
                return dates != [] && times.horarioInicial != null && times.horarioFinal != null && dates[0] != null && dates[1] != null 
            } else if(times.tipoHorario.includes('SEMANAL')){
                return times.horarioInicial != null && dates[0] != null && dates[1] != null 
            }

            return false
        }

        if(isValid()){
            let dateInitial = dates[0]?.toLocaleDateString('pt-br').split('/').reverse().join('-')
            let dateEnd = dates[1]?.toLocaleDateString('pt-br').split('/').reverse().join('-')
            let listDateLimeLocalStorage = getListTimeLocalStorage()
    
            if(!isNull(dateInitial) && !isNull(dateEnd)){
                if(props.data.id){
                    props.update(times, true)
                } else {
                    times.dataInicial = dateInitial
                    times.dataFinal = dateEnd
                    times.id = ++listDateLimeLocalStorage.length
                    times.quantidadePessoas = times.quantidadePessoas ? times.quantidadePessoas : 0
                    props.update(times)
                }
                props.onHide()
            }
        }
        
    }

    useEffect(() => {
        setVisible(props.visible)
        if(visible){
            setDates([])
        }
        
        if(props.data?.id){
            setTimes(props.data)
            setVisibleDataTime(props.data.tipoHorario)
        } else {
            setTimes({})
            setVisibleDataTime('Typetime')
        }

    }, [props.visible, props.data])

    return (
        <>
        {/* @ts-ignore */}
            <Dialog header="Horários da aventura" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
                <Formik initialValues={[]} onSubmit={onSubmit}>
                    <Form>
                        <InputGroup inputs={1}>
                        <Input
                            as="select"
                            label="Selecione o tipo de horário"
                            name="tipoHorario"
                            options={listOption}
                            value={visibleTypeDataTime}
                            onChange={(e: any) => {
                                setVisibleDataTime(e.target.value)
                                {/* @ts-ignore */}
                                setTimes(prevState => {
                                    return { ...prevState, tipoHorario: e.target.value }
                                })
                            }}
                        />
                        </InputGroup>
                        <InputGroup inputs={1}> 
                            {
                                (visibleTypeDataTime === 'DATA') && (
                                    <>
                                    {/* @ts-ignore */}
                                        <Calendar selectionMode="range" minDate={new Date()} showButtonBar inline dateFormat="dd/mm/yy" value={dates} onChange={(e) => setDates(e.target.value)}></Calendar>
                                        { formatStringData(dates) }
                                        <InputGroup inputs={2}>
                                            <InputContainer>
                                                <Input
                                                    label="Inicio"
                                                    name="inicio"
                                                    mask="99:99"
                                                    value={times.horarioInicial || null}
                                                    onChange={(e: any) => {
                                                        {/* @ts-ignore */}
                                                        setTimes(prevState => {
                                                            return { ...prevState, horarioInicial: e.target.value }
                                                        })
                                                    }}
                                                />
                                            </InputContainer>
                                            <InputContainer>
                                                <Input
                                                    label="Fim"
                                                    name="fim"
                                                    mask="99:99"
                                                    value={times.horarioFinal || null}
                                                    onChange={(e: any) => {
                                                        {/* @ts-ignore */}
                                                        setTimes(prevState => {
                                                            return { ...prevState, horarioFinal: e.target.value }
                                                        })
                                                    }}
                                                />
                                            </InputContainer>
                                        </InputGroup>
                                        <InputGroup inputs={1}>
                                            <InputContainer>
                                                <Input
                                                    label="Quantidade de pessoas"
                                                    name="quantidade"
                                                    type="number"
                                                    value={times.quantidadePessoas || 0}
                                                    onChange={(e: any) => {
                                                        {/* @ts-ignore */}
                                                        setTimes(prevState => {
                                                            return { ...prevState, quantidadePessoas: e.target.value }
                                                        })
                                                    }}
                                                />
                                            </InputContainer>
                                            <p style={{ fontSize: '10px', textAlign: 'left' }}> (deixe 0 caso queira que seja aberto) </p>
                                        </InputGroup>
                                        <Button text="Salvar" type="button" onClick={onSubmit}/>
                                    </>
                                ) || (visibleTypeDataTime === 'SEMANAL') && (
                                    <>
                                    {/* @ts-ignore */}
                                        <Calendar selectionMode="range" minDate={new Date()} showButtonBar inline dateFormat="dd/mm/yy" value={dates} onChange={(e) => setDates(e.target.value)}></Calendar>
                                        { formatStringData(dates) }
                                        <InputGroup inputs={1}>
                                            <Input
                                                as="select"
                                                label="Dias da semana"
                                                name="diasSemana"
                                                options={listOptionDaysWeek}
                                                value={times.diaSemana || listOptionDaysWeek[0]}
                                                onChange={(e: any) => {
                                                    {/* @ts-ignore */}
                                                    setTimes(prevState => {
                                                        return { ...prevState, diaSemana: e.target.value }
                                                    })
                                                }}
                                            />
                                        </InputGroup>
                                        <InputGroup inputs={2}>
                                            <InputContainer>
                                                <Input
                                                    label="Inicio"
                                                    name="inicio"
                                                    mask="99:99"
                                                    value={times.horarioInicial || null}
                                                    onChange={(e: any) => {
                                                        {/* @ts-ignore */}
                                                        setTimes(prevState => {
                                                            return { ...prevState, horarioInicial: e.target.value }
                                                        })
                                                    }}
                                                />
                                            </InputContainer>
                                            <InputContainer>
                                                <Input
                                                type="number"
                                                label="Quantidade de pessoas"
                                                name="quantidadePessoas"
                                                value={times.quantidadePessoas || 0}
                                                onChange={(e: any) => {
                                                    {/* @ts-ignore */}
                                                    setTimes(prevState => {
                                                        return { ...prevState, quantidadePessoas: e.target.value }
                                                    })
                                                }}
                                                />
                                            </InputContainer>
                                        </InputGroup>
                                        <Button type="button" text="Salvar" onClick={onSubmit} />
                                    </>
                                ) || visibleTypeDataTime === 'Typetime' && (<></>)
                            }
                        </InputGroup>
                    </Form>
                </Formik>
            </Dialog>
        </>
    )
}