import { Button } from 'primereact/button';
import { Dialog } from 'primereact/dialog';
import { Toast } from 'primereact/toast';
import { useRef } from 'react';
import api from '../../../core/services/api';
import { ButtonsContainer } from './styles';
import { useRouter } from 'next/router';

export interface IModalProps {
  visible: boolean;
  setVisible: React.Dispatch<React.SetStateAction<boolean>>;
  selected: any;
}

export default function ModalChangeSubscriberStatus({
  visible,
  setVisible,
  selected: subscribed,
}: IModalProps) {
  const router = useRouter();
  async function changePresence(newStatus: string) {
    if (!subscribed || subscribed.statusPresenca === newStatus) return;
    await api
      .post(
        '/WS/ClienteAventuraAcompanhante/AlterarPresenca/' +
          subscribed.acompanhanteId +
          '?novoStatus=' +
          newStatus,
        {}
      )
      .then(() => {
        router.replace(router.asPath);
      })
      .catch(console.error)
      .finally(() => setVisible(false));
  }

  const toast = useRef(null);
  return (
    <>
    {/* @ts-ignore */}
      <Toast ref={toast} position="top-center" />
      {/* @ts-ignore */}
      <Dialog
        visible={visible}
        style={{ width: '50vw' }}
        onHide={() => setVisible(false)}
        header="Atenção"
      >
        <title>Atençao</title>
        <span>
          Você deve informar se o cliente esteve presente durante a aventura. O
          cliente:
        </span>
        <ButtonsContainer>
          {/* @ts-ignore */}
          <Button
            label="Não compareceu"
            className="p-button-text"
            onClick={() => changePresence('AUSENTE')}
          />
          {/* @ts-ignore */}
          <Button
            label="Compareceu"
            className="p-button-text"
            onClick={() => changePresence('PRESENTE')}
          />
          {/* @ts-ignore */}
          <Button
            label="Cancelar operação"
            className="p-button-text"
            onClick={() => setVisible(false)}
          />
        </ButtonsContainer>
      </Dialog>
    </>
  );
}
