import { Dialog } from "primereact/dialog"
import { Formik, Form } from "formik";
import Button from "../Button";
import { useEffect, useReducer, useRef, useState } from "react";
import Input  from "../CustomInput";
import { InputGroup, InputContainer } from "./styles";
import useMaterial from "../../../core/hooks/useMaterial";
import { Util } from "../../../core/utils/util";
import { Toast } from "primereact/toast";


export default function MaterialModal(props: any) {
    
    const toast = useRef(null);
    const { saveDataMaterial } = useMaterial()
    const [visible, setVisible] = useState(false)
    const [material, setMaterial] = useState({
        descricao: null,
        descricaoEn: null,
        descricaoEs: null
    })
    const [_, forceUpdate] = useReducer((x) => x + 1, 0);

    const saveMaterialDataDto = async () => {
        if(props.data && props.data.id){
            setMaterial(prevState => {
                return { ...prevState, id: props.data.id }
            })
            props.data.descricao = material.descricao
            props.data.descricaoEn = material.descricaoEn
            props.data.descricaoEs = material.descricaoEs
        }

        if(material && material.descricao && material.descricaoEn && material.descricaoEs){
            const response = await saveDataMaterial(material)
            if(response.status === 200){
                Util.showSucessToast(toast, "Material salvo com sucesso");
            } else {
                Util.showErrorToast(toast, "Erro ao salvar material");
            }
        } else {
            Util.showErrorToast(toast, "Preencha todos os campos");
        }

        forceUpdate()
        setMaterial({
            descricao: null,
            descricaoEn: null,
            descricaoEs: null
        })
        props.onHide()
    }

    useEffect(() => {
        setVisible(props.visible)
        setMaterial(props.data)
    }, [props.visible])

    return(
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />
        {/* @ts-ignore */}
        <Dialog header={material?.id ? "Salvar Material" : "Novo material" } visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
        {/* @ts-ignore */}
            <Formik>
            <Form>
            <InputGroup inputs={1}>
                <InputContainer>
                    <Input
                        name="nomePortugues"
                        label="Nome em portugues"
                        placeholder="Capacete"
                        value={material?.descricao || ""}
                        onChange={(i: any) => setMaterial(prevState => {
                            return { ...prevState, descricao: i.target.value }
                        })}
                    />
                </InputContainer>
                <InputContainer>
                    <Input
                        name="nomeIngles"
                        label="Nome em inglês"
                        placeholder="Helmet"
                        value={material?.descricaoEn || ""}
                        onChange={(i: any) => setMaterial(prevState => {
                            return { ...prevState, descricaoEn: i.target.value }
                        })}
                    />
                </InputContainer>
                <InputContainer>
                    <Input 
                        name="nomeEspanhol"
                        label="Nome em espanhol"
                        placeholder="Casco"
                        value={material?.descricaoEs || ""}
                        onChange={(i: any) => setMaterial(prevState => {
                            return { ...prevState, descricaoEs: i.target.value }
                        })}
                    />
                </InputContainer>
            </InputGroup>
                <Button type="button" onClick={() => saveMaterialDataDto()} text="Salvar alterações"></Button>
            </Form>
            </Formik>
        </Dialog>
        </>
    )
}