import { Dialog } from "primereact/dialog"
import { useEffect, useRef, useState } from "react"
import Button from "../../Button"
import { InputGroup } from './styles'
import useMaterial from "../../../../core/hooks/useMaterial"
import { Util } from "../../../../core/utils/util"
import { Toast } from "primereact/toast"

export default function DeleteModalMaterial(props: any){
    const toast = useRef(null);
    const [visible, setVisible] = useState(false)
    const [material, setMaterial] = useState({})
    const { deleteDataMaterial } = useMaterial()

    useEffect(() => {
        setVisible(props.visible)
        setMaterial(props.data)
    }, [props.visible])

    const deleteMaterialDataDto = async () => {
        {/* @ts-ignore */}
        if(material && material?.id){
            const response = await deleteDataMaterial(material)
            if(response.status === 204){
                Util.showSucessToast(toast, "Material excluido com sucesso");
            } else {
                Util.showErrorToast(toast, "Erro ao excluir material");
            }
        }

        props.onHide()
    }

    return (
        <>
        {/* @ts-ignore */}
        <Toast ref={toast} position="top-center" />
{/* @ts-ignore */}
        <Dialog header="Excluir material" visible={visible} style={{ width: '50vw' }} onHide={() => props.onHide()}>
            <div>
                Você tem certeza que deseja excluir o material ? A operação não poder desfeita.
            </div>
            <br/>
            <InputGroup inputs={2}>
                <Button type="button" color="#495057a3" onClick={() => props.onHide()} text="Não"></Button>
                <Button type="button" onClick={() => deleteMaterialDataDto() } text="Sim"></Button>
            </InputGroup>
        </Dialog>
        </>
    )
}