import React, { InputHTMLAttributes, ReactHTMLElement } from "react";
import styled from "styled-components";
import useMasks from "../../../core/hooks/useMasks";

interface InputFilterProps extends InputHTMLAttributes<HTMLInputElement> {
  mask?: "numbers";
}

function InputFilter({ mask, ...rest }: InputFilterProps) {
  const { onlyNumbers } = useMasks();

  const onInput = (event: React.ChangeEvent<HTMLInputElement>) => {
    switch (mask) {
      case "numbers":
        event.target.value = onlyNumbers(event?.target?.value);
        break;

      default:
        event.target.value = event?.target?.value;
        break;
    }
  };

  return <Input {...rest} onInput={onInput} />;
}

export default React.memo(InputFilter);

const Input = styled.input`
  display: block;
  width: 100%;
  padding: 6px 12px;
  font-size: 16px;
  line-height: 1.42857143;
  color: #555;
  background-color: #fff;
  background-image: none;
  border: 1px solid #ccc;
  border-radius: 4px;
  background: #ffffff 0% 0% no-repeat padding-box;
  box-shadow: 0px 3px 10px #00000021;
  border-color: none;
  border: none;
  outline: none;
  padding-left: 40px;
  height: 45px;
  font-family: "Poppins";

  &::placeholder {
    color: #c3c3c3;
    font-size: 16px;
  }

  :enabled:hover {
    border-color: none;
    border: none;
  }
  :enabled:focus {
    background: #ffffff 0% 0% no-repeat padding-box;
    box-shadow: 0px 3px 10px #00000021;
    border: none;
  }

  *:focus {
  }
`;
