import styled from "styled-components";

export const Wrapper = styled.div`
  min-height: 100px;
  width: 100%;
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  align-items: center;
  flex-wrap: wrap;

  @media screen and (max-width: 767px) {
    flex-direction: row;
    justify-content: center;

    margin: 5px;
  }

  .ReactCollapse--collapse {
    transition: height 300ms;
    width: 100%;
  }
`;

export const SimpleFilters = styled.div`
  min-height: 100px;
  width: 100%;
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  align-items: center;
  flex-wrap: wrap;

  @media screen and (max-width: 767px) {
    flex-direction: row;
    justify-content: center;
  }
`;

export const Elements = styled.div`
  height: 100%;
  display: flex;
  flex-direction: row;
`;

export const ElementContainer = styled.div`
  color: ${(p) => p.theme.pageForeground};
  text-transform: capitalize;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  margin: 10px 10px;
  cursor: pointer;

  :active {
    opacity: 0.5;
  }
`;

export const ElementName = styled.text<{ color?: string }>`
  text-align: center;
  font: normal normal 600 10px/14px Poppins;
  letter-spacing: 0px;
  color: ${(p) => (p.color ? p.color : p.theme.inactiveElementBackground)};
  opacity: 1;
  margin-top: 10px;
`;

export const InputWrapper = styled(Elements)`
  width: 50%;
  height: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  a {
    text {
      color: ${(p) => p.theme.primaryBackground};
    }
  }
  @media screen and (max-width: 767px) {
    width: 100%;
  }
`;
export const ButtonContainer = styled.div`
  width: 30%;
  height: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  margin-left: 10px;
  a {
    text {
      color: ${(p) => p.theme.primaryBackground};
    }
  }
`;

export const FilterTitle = styled.text<{ rotateAnimation: boolean }>`
  font-size: 16px;
  width: 100%;
  text-align: right;
  display: flex;
  justify-content: flex-end;
  align-items: center;
  cursor: pointer;
  margin: 10px 0;

  svg {
    transition: 300ms ease;
    transform: rotate(${(p) => (p.rotateAnimation ? "180deg" : "0deg")});
  }
`;

export const InputContainer = styled.div`
  width: 100%;
  display: flex;
  flex-direction: column;
  margin: 0 4px;

  label {
    margin: 5px 0;
    font-size: 16px;
    padding: 5px;
  }
`;

export const FiltersContainer = styled.div`
  width: 100%;
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  margin: 10px 0;

  @media screen and (max-width: 767px) {
    flex-wrap: wrap;
  }

  svg {
    z-index: 99;
  }
`;

export const AutoComplete = styled.div<{ visible: boolean }>`
  display: ${(p) => (p.visible ? "block" : "none")};
  background-color: white;
  border: none;
  box-shadow: 0 1px 0 rgba(0, 0, 0, 0.06);
  box-sizing: border-box;
  margin-top: -1px;
  max-height: 200px;
  overflow-y: auto;
  position: absolute;
  top: 100%;
  width: 100%;
  z-index: 1000;
  -webkit-overflow-scrolling: touch;
`;
